/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.util;

import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.util.AttributeUpdater;
import com.mulesoft.mule.debugger.util.FieldUpdater;
import com.mulesoft.mule.debugger.util.PayloadUpdater;
import com.mulesoft.mule.debugger.util.VariableUpdater;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class UpdaterUtils {
    private static final Map<String, Supplier<FieldUpdater>> FIELD_UPDATER_SUPPLIER;

    private UpdaterUtils() {
        throw new IllegalStateException("Not meant to be instanciated");
    }

    public static FieldUpdater getUpdaterFor(FieldPath fieldPath) {
        String rootExpression = fieldPath.getRootExpression();
        return FIELD_UPDATER_SUPPLIER.getOrDefault(rootExpression, () -> new FieldUpdater(){}).get();
    }

    static {
        HashMap<String, Supplier<FieldUpdater>> fieldUpdaters = new HashMap<String, Supplier<FieldUpdater>>();
        fieldUpdaters.put("payload", PayloadUpdater::new);
        fieldUpdaters.put("vars", VariableUpdater::new);
        fieldUpdaters.put("attributes", AttributeUpdater::new);
        FIELD_UPDATER_SUPPLIER = Collections.unmodifiableMap(fieldUpdaters);
    }
}

