/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.client.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.client.impl.ClientCommunicationService;
import com.mulesoft.mule.debugger.client.impl.DebuggerEventFactory;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DebuggerClientConnectionHandlerImpl
implements IDebuggerClientConnectionHandler {
    private final Lock singleClient = new ReentrantLock();
    private final List<IDebuggerClientConnectionListener> listeners = new ArrayList<IDebuggerClientConnectionListener>();
    private ClientCommunicationService communicationService;

    @Override
    public void addListener(IDebuggerClientConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public ClientCommunicationService getClientCommunicationService() {
        return this.communicationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectClient(ClientCommunicationService communicationService) {
        if (this.singleClient.tryLock()) {
            try {
                this.communicationService = communicationService;
                for (IDebuggerClientConnectionListener listener : this.listeners) {
                    listener.onClientConnected();
                }
                this.communicationService.sendEvent((IDebuggerResponse)DebuggerEventFactory.createConnectionEstablishedEvent());
                this.communicationService.start();
            }
            finally {
                this.singleClient.unlock();
            }
        }
    }

    @Override
    public boolean isClientConnected() {
        return this.communicationService != null;
    }

    @Override
    public void disconnectClient() {
        if (!this.isClientConnected()) {
            return;
        }
        for (IDebuggerClientConnectionListener listener : this.listeners) {
            listener.onClientDisconnected();
        }
        this.communicationService.stop();
        this.communicationService = null;
    }
}

