/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.command;

import com.mulesoft.mule.debugger.builder.MuleMessageInfoBuilder;
import com.mulesoft.mule.debugger.builder.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.command.AbstractCommand;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.dto.ScriptResultInfo;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.request.ExecuteScriptRequest;
import com.mulesoft.mule.debugger.response.ExecuteScriptResponse;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;

public class ExecuteScriptCommand
extends AbstractCommand<ExecuteScriptRequest> {
    private static final String MESSAGE = "TypedValue[value: '%s', dataType: '%s']";

    @Override
    public IDebuggerResponse execute() {
        try {
            ScriptResultInfo scriptEvaluationInfo = this.evalScript();
            return new ExecuteScriptResponse(scriptEvaluationInfo);
        }
        catch (Exception e) {
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }

    private ScriptResultInfo evalScript() {
        String script = ((ExecuteScriptRequest)this.getRequest()).getScript();
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        TypedValue result = debuggingMessage.evaluateExpression(script);
        Object resultValue = result.getValue();
        Class resultValueClass = resultValue == null ? Object.class : resultValue.getClass();
        ObjectFieldDefinition fromObject = ObjectFieldDefinitionFactory.createFromObject(resultValue, script, script, debuggingMessage.getCharset(), script);
        MuleMessageInfoBuilder.addMimeTypeToDefinition(result, fromObject);
        MediaType resultMediaType = result.getDataType().getMediaType();
        String typedValueString = resultValue != null ? String.valueOf(result) : String.format(MESSAGE, "null", result.getDataType());
        return new ScriptResultInfo(MuleMessageInfoBuilder.create(debuggingMessage), fromObject, String.valueOf(resultValueClass), typedValueString, resultMediaType.getPrimaryType() + "/" + resultMediaType.getSubType());
    }
}

