/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.command;

import com.mulesoft.mule.debugger.builder.MuleMessageInfoBuilder;
import com.mulesoft.mule.debugger.builder.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.command.AbstractCommand;
import com.mulesoft.mule.debugger.dto.FieldNode;
import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.request.LoadInnerFieldsRequest;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.LoadInnerFieldsResponse;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.server.impl.FieldPathAccessor;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadInnerFieldsCommand
extends AbstractCommand<LoadInnerFieldsRequest> {
    private static final Logger logger = LoggerFactory.getLogger(LoadInnerFieldsCommand.class);

    @Override
    public IDebuggerResponse execute() {
        FieldPath fieldPath = ((LoadInnerFieldsRequest)this.getRequest()).getParentPath();
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        String script = fieldPath.getRootExpression();
        try {
            Charset charset;
            ArrayList<FieldNode> orderedPathElements;
            Object rootElement;
            logger.debug("Load Inner Fields From: {}", (Object)fieldPath);
            if ("SYNTHETIC_OPERATION_ROOT".equals(script) || "SYNTHETIC_OPERATION_ERROR_ROOT".equals(script)) {
                FieldNode fieldNode = (FieldNode)fieldPath.getOrderedPathElements().get(0);
                ProcessorParameterValue processorParameterValue = debuggingMessage.getParameters().get(fieldNode.getName());
                try {
                    rootElement = processorParameterValue.resolveValue();
                }
                catch (MuleRuntimeException exception) {
                    rootElement = exception;
                }
                orderedPathElements = new ArrayList<FieldNode>(fieldPath.getOrderedPathElements());
                orderedPathElements.remove(0);
                charset = debuggingMessage.getCharset();
            } else {
                TypedValue rootElementTyped = debuggingMessage.evaluateExpression(script);
                rootElement = rootElementTyped.getValue();
                orderedPathElements = fieldPath.getOrderedPathElements();
                charset = MuleMessageInfoBuilder.calculateCharset(rootElementTyped.getDataType());
            }
            return this.loadInnerFieldsFrom(fieldPath, rootElement, orderedPathElements, charset, script);
        }
        catch (Exception e) {
            logger.warn("Error while evaluating path" + fieldPath, (Throwable)e);
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }

    private IDebuggerResponse loadInnerFieldsFrom(FieldPath fieldPath, Object rootElement, List<FieldNode> orderedPathElements, Charset rootElementCharset, String rootElementScript) throws IllegalAccessException {
        Object result = FieldPathAccessor.get(orderedPathElements.iterator(), rootElement);
        String dwAccessor = FieldPathAccessor.getDWAccessor(orderedPathElements.iterator(), rootElement, rootElementScript);
        String rootExpression = fieldPath.getRootExpression();
        ObjectFieldDefinition fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(result, rootExpression, fieldPath, rootElementCharset, dwAccessor);
        return new LoadInnerFieldsResponse(fieldDefinition);
    }
}

