/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.command;

import com.mulesoft.mule.debugger.command.AbstractCommand;
import com.mulesoft.mule.debugger.request.SchedulerRequest;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.source.SchedulerMessageSource;

public class SchedulerCommand
extends AbstractCommand<SchedulerRequest> {
    @Override
    public IDebuggerResponse execute() {
        try {
            ConfigurationComponentLocator locator = this.getComponentLocatorProvider().getLocator(((SchedulerRequest)this.getRequest()).getAppName());
            List possibleSchedulers = locator.find(ComponentIdentifier.buildFromStringRepresentation((String)"mule:scheduler"));
            Stream<Object> flowConstructStream = possibleSchedulers.stream();
            if (!((SchedulerRequest)this.getRequest()).isApplyToAll()) {
                flowConstructStream = flowConstructStream.filter(messageSource -> ((LocationPart)messageSource.getLocation().getParts().get(0)).getPartPath().equals(((SchedulerRequest)this.getRequest()).getFlow()));
            }
            Stream<SchedulerMessageSource> schedulerMessageSourceStream = flowConstructStream.filter(messageSource -> messageSource instanceof SchedulerMessageSource).map(messageSource -> (SchedulerMessageSource)messageSource);
            return ((SchedulerRequest)this.getRequest()).getAction().executeOver(schedulerMessageSourceStream.collect(Collectors.toList()));
        }
        catch (Exception e) {
            return new ErrorResponse(e.getMessage());
        }
    }
}

