/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.command;

import com.mulesoft.mule.debugger.builder.MuleMessageInfoBuilder;
import com.mulesoft.mule.debugger.builder.ObjectFieldDefinitionFactory;
import com.mulesoft.mule.debugger.command.AbstractCommand;
import com.mulesoft.mule.debugger.dto.FieldNode;
import com.mulesoft.mule.debugger.dto.FieldPath;
import com.mulesoft.mule.debugger.dto.ObjectFieldDefinition;
import com.mulesoft.mule.debugger.exception.RemoteDebugException;
import com.mulesoft.mule.debugger.request.UpdateFieldRequest;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.ScriptExceptionResponse;
import com.mulesoft.mule.debugger.response.UpdatedFieldResponse;
import com.mulesoft.mule.debugger.server.impl.FieldPathAccessor;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import com.mulesoft.mule.debugger.util.FieldUpdater;
import com.mulesoft.mule.debugger.util.UpdaterUtils;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.metadata.TypedValue;

public class UpdateFieldCommand
extends AbstractCommand<UpdateFieldRequest> {
    @Override
    public IDebuggerResponse execute() {
        FieldPath fieldPath = ((UpdateFieldRequest)this.getRequest()).getPath();
        MuleDebuggingContext debuggingMessage = this.getMuleDebuggingMessage();
        String rootElementScript = fieldPath.getRootExpression();
        FieldUpdater updater = UpdaterUtils.getUpdaterFor(fieldPath);
        try {
            ObjectFieldDefinition fieldDefinition;
            TypedValue rootElement = debuggingMessage.evaluateExpression(rootElementScript);
            TypedValue typedValue = debuggingMessage.evaluateExpression(((UpdateFieldRequest)this.getRequest()).getValue());
            List orderedPathElements = fieldPath.getOrderedPathElements();
            if (orderedPathElements.isEmpty()) {
                fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(typedValue.getValue(), rootElementScript, fieldPath, debuggingMessage.getCharset(), rootElementScript);
                updater.update(debuggingMessage, typedValue.getValue());
            } else {
                Optional<Object> updatedRoot = FieldPathAccessor.update(orderedPathElements.iterator(), rootElement.getValue(), typedValue.getValue(), Optional.empty(), Optional.empty());
                Object result = FieldPathAccessor.get(orderedPathElements.iterator(), updatedRoot.orElseGet(() -> ((TypedValue)rootElement).getValue()));
                String dwAccessor = FieldPathAccessor.getDWAccessor(orderedPathElements.iterator(), updatedRoot.orElseGet(() -> ((TypedValue)rootElement).getValue()), rootElementScript);
                if (result instanceof TypedValue) {
                    result = ((TypedValue)result).getValue();
                }
                fieldDefinition = ObjectFieldDefinitionFactory.createFromObject(result, ((FieldNode)orderedPathElements.get(orderedPathElements.size() - 1)).getName(), fieldPath, debuggingMessage.getCharset(), dwAccessor);
                if (updatedRoot.isPresent()) {
                    updater.update(debuggingMessage, updatedRoot.get());
                } else {
                    updater.update(debuggingMessage, rootElement.getValue());
                }
            }
            if (rootElementScript.equals("payload") || rootElementScript.equals("vars")) {
                MuleMessageInfoBuilder.addMimeTypeToDefinition(typedValue, fieldDefinition);
            }
            return new UpdatedFieldResponse(fieldDefinition);
        }
        catch (Exception e) {
            return new ScriptExceptionResponse(new RemoteDebugException(e.getMessage(), e));
        }
    }
}

