/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.handler.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.dto.Breakpoint;
import com.mulesoft.mule.debugger.handler.impl.ApplicationBreakpointHandler;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreakpointHandler
implements IDebuggerClientConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(BreakpointHandler.class);
    private final Map<String, ApplicationBreakpointHandler> breakpointsByApp = new HashMap<String, ApplicationBreakpointHandler>();
    private boolean exceptionBreakpoint = false;

    private BreakpointHandler() {
    }

    public static BreakpointHandler create(IDebuggerClientConnectionHandler clientConnectionHandler) {
        BreakpointHandler result = new BreakpointHandler();
        clientConnectionHandler.addListener(result);
        return result;
    }

    public boolean isBreakpointOn(MuleExpressionLanguage muleExpressionLanguage, InterceptionEvent interceptionEvent, ComponentLocation componentLocation, String appName, TransformationService transformationService) {
        Breakpoint breakpoint;
        Boolean result = false;
        ApplicationBreakpointHandler applicationBreakpointHandler = this.breakpointsByApp.get(appName);
        MuleDebuggingContext debuggingContext = new MuleDebuggingContext(muleExpressionLanguage, interceptionEvent, componentLocation, appName, transformationService);
        if (applicationBreakpointHandler != null && (breakpoint = applicationBreakpointHandler.searchFlowBreakpointOn(debuggingContext.getComponentLocation())) != null) {
            if (breakpoint.hasCondition()) {
                Object evaluate;
                try {
                    evaluate = debuggingContext.evaluateExpression(breakpoint.getCondition());
                }
                catch (Exception e) {
                    logger.error("Expression Failed " + breakpoint.getCondition(), (Throwable)e);
                    evaluate = true;
                }
                if (evaluate instanceof Boolean) {
                    result = (Boolean)evaluate;
                } else if (evaluate instanceof TypedValue) {
                    TypedValue typedValue = evaluate;
                    Object objectValue = typedValue.getValue();
                    if (typedValue.getDataType().equals(DataType.BOOLEAN) || typedValue.getValue() instanceof Boolean) {
                        result = (Boolean)objectValue;
                    } else {
                        logger.warn("Breakpoint condition result must be Boolean and is {}", objectValue.getClass());
                        result = true;
                    }
                } else {
                    logger.warn("Breakpoint condition result must be Boolean and is {}", result.getClass());
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public boolean isExceptionBreakpoint() {
        return this.exceptionBreakpoint;
    }

    public void setExceptionBreakpoint(boolean exceptionBreakpoint) {
        this.exceptionBreakpoint = exceptionBreakpoint;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        String applicationName = breakpoint.getApplicationName();
        ApplicationBreakpointHandler applicationBreakpointHandler = this.getApplicationBreakpointsHandler(applicationName);
        applicationBreakpointHandler.addBreakpoint(breakpoint);
    }

    private ApplicationBreakpointHandler getApplicationBreakpointsHandler(String applicationName) {
        return this.breakpointsByApp.computeIfAbsent(applicationName, k -> new ApplicationBreakpointHandler());
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        ApplicationBreakpointHandler applicationBreakpointHandler = this.breakpointsByApp.get(breakpoint.getApplicationName());
        if (applicationBreakpointHandler != null) {
            applicationBreakpointHandler.removeBreakpoint(breakpoint);
        }
    }

    public Collection<Breakpoint> getBreakpointsByApp(String appName) {
        ApplicationBreakpointHandler applicationBreakpointHandler = this.breakpointsByApp.get(appName);
        return applicationBreakpointHandler == null ? null : applicationBreakpointHandler.getBreakpoints();
    }

    @Override
    public void onClientConnected() {
    }

    @Override
    public void onClientDisconnected() {
        this.breakpointsByApp.clear();
        this.exceptionBreakpoint = false;
    }
}

