/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.handler.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.handler.IMuleNotificationHandler;
import com.mulesoft.mule.debugger.handler.impl.BreakpointHandler;
import com.mulesoft.mule.debugger.handler.impl.MessageNotificationsStatus;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.response.ResumeResponse;
import com.mulesoft.mule.debugger.server.CorrelationIdProvider;
import com.mulesoft.mule.debugger.server.IDebuggerManager;
import com.mulesoft.mule.debugger.server.impl.MuleDebuggingContext;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationHandlerImpl
implements IMuleNotificationHandler {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationHandlerImpl.class);
    private final IDebuggerClientConnectionHandler clientConnectionHandler;
    private final IDebuggerManager messageDebuggerManager;
    private final BreakpointHandler breakpointHandler;
    private final ConcurrentHashMap<String, MessageNotificationsStatus> notificationsStatusMap;

    public MuleNotificationHandlerImpl(BreakpointHandler breakpointHandler, IDebuggerManager messageDebuggerManager, IDebuggerClientConnectionHandler clientConnectionHandler) {
        this.breakpointHandler = breakpointHandler;
        this.messageDebuggerManager = messageDebuggerManager;
        this.clientConnectionHandler = clientConnectionHandler;
        this.notificationsStatusMap = new ConcurrentHashMap();
    }

    @Override
    public void onApplicationDown(String applicationName) {
        MuleDebuggingContext currentEvent = this.messageDebuggerManager.getMuleExecutionManager().getDebuggingEvent();
        if (currentEvent != null && currentEvent.getAppName().equals(applicationName)) {
            this.messageDebuggerManager.stopAllDebuggingSessions();
        }
    }

    @Override
    public void onMuleMessageArrived(MuleDebuggingContext muleDebuggingContext) {
        if (!this.clientConnectionHandler.isClientConnected() || this.isASmartConnector(muleDebuggingContext.getComponentLocation())) {
            return;
        }
        if (this.breakpointHandler.isBreakpointOn(muleDebuggingContext.getExpressionManager(), muleDebuggingContext.getInterceptionEvent(), muleDebuggingContext.getComponentLocation(), muleDebuggingContext.getAppName(), muleDebuggingContext.getTransformationService())) {
            this.messageDebuggerManager.isStepping(muleDebuggingContext.getIdProvider());
            this.messageDebuggerManager.startDebugging(muleDebuggingContext.getInterceptionEvent());
            this.messageDebuggerManager.getMuleExecutionManager().stopExecution(muleDebuggingContext);
        } else if (Boolean.TRUE.equals(this.messageDebuggerManager.isStepping(muleDebuggingContext.getIdProvider()))) {
            this.messageDebuggerManager.startDebugging(muleDebuggingContext.getInterceptionEvent());
            this.messageDebuggerManager.getMuleExecutionManager().stopExecution(muleDebuggingContext);
        } else {
            this.messageDebuggerManager.setStepping(muleDebuggingContext.getInterceptionEvent(), false);
        }
    }

    private boolean isASmartConnector(ComponentLocation componentLocation) {
        List parts = componentLocation.getParts();
        if (!parts.isEmpty()) {
            return ((LocationPart)parts.get(0)).getPartIdentifier().map(TypedComponentIdentifier::getType).map(arg_0 -> TypedComponentIdentifier.ComponentType.OPERATION.equals(arg_0)).orElse(false);
        }
        return false;
    }

    @Override
    public void onMuleMessageLeft(MuleDebuggingContext debuggingContext) {
    }

    @Override
    public void onMuleMessageLeftWithException(MuleDebuggingContext debuggingContext, Throwable exception) {
        if (!this.clientConnectionHandler.isClientConnected() || !this.breakpointHandler.isExceptionBreakpoint() || this.isASmartConnector(debuggingContext.getComponentLocation())) {
            return;
        }
        this.messageDebuggerManager.isStepping(debuggingContext.getIdProvider());
        this.messageDebuggerManager.startDebugging(debuggingContext.getInterceptionEvent());
        this.messageDebuggerManager.getMuleExecutionManager().stopExecution(debuggingContext, exception);
    }

    @Override
    public void onPipelineStartReached(CorrelationIdProvider muleEvent) {
        this.getMessageNotificationsStatus(muleEvent).flowStarted();
    }

    @Override
    public void onPipelineCompleteReached(CorrelationIdProvider muleEvent) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(muleEvent);
        messageNotificationsStatus.flowEnded();
        this.checkFinished(muleEvent, messageNotificationsStatus);
    }

    @Override
    public void onFlowStarted(CorrelationIdProvider correlationIdProvider) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(correlationIdProvider);
        messageNotificationsStatus.sourceFlowStarted();
        this.checkFinished(correlationIdProvider, messageNotificationsStatus);
    }

    @Override
    public void onFlowEnded(CorrelationIdProvider correlationIdProvider) {
        MessageNotificationsStatus messageNotificationsStatus = this.getMessageNotificationsStatus(correlationIdProvider);
        messageNotificationsStatus.sourceFlowEnded();
        this.checkFinished(correlationIdProvider, messageNotificationsStatus);
    }

    @Override
    public void onFlowEndedWithException(CorrelationIdProvider correlationIdProvider, Throwable thrown) {
    }

    private MessageNotificationsStatus getMessageNotificationsStatus(CorrelationIdProvider muleEvent) {
        MessageNotificationsStatus newValue;
        String correlationId = muleEvent.getCorrelationId();
        MessageNotificationsStatus result = this.notificationsStatusMap.get(correlationId);
        if (result == null && (result = this.notificationsStatusMap.putIfAbsent(correlationId, newValue = new MessageNotificationsStatus())) == null) {
            result = newValue;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinished(CorrelationIdProvider muleEvent, MessageNotificationsStatus messageNotificationsStatus) {
        String correlationId = muleEvent.getCorrelationId();
        MessageNotificationsStatus messageNotificationsStatus2 = messageNotificationsStatus;
        synchronized (messageNotificationsStatus2) {
            if (messageNotificationsStatus.isFinish()) {
                this.stopDebugging(muleEvent, correlationId);
            }
        }
    }

    private void stopDebugging(CorrelationIdProvider muleEvent, String correlationId) {
        this.notificationsStatusMap.remove(correlationId);
        if (!this.clientConnectionHandler.isClientConnected()) {
            logger.debug("Client is not connected");
        } else if (!this.messageDebuggerManager.isDebuggingThisMessage(muleEvent)) {
            logger.debug("Not debugging this message: {}", (Object)correlationId);
        } else if (this.messageDebuggerManager.isStepping(muleEvent) == null) {
            logger.debug("Not stepping");
        } else {
            this.messageDebuggerManager.stopDebugging();
            this.clientConnectionHandler.getClientCommunicationService().sendEvent((IDebuggerResponse)new ResumeResponse());
        }
    }
}

