/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.mule.notification;

import com.mulesoft.mule.debugger.handler.IMuleNotificationHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.AsyncMessageNotificationListener;
import org.mule.runtime.api.notification.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerAsyncMessageNotificationListener
implements AsyncMessageNotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerAsyncMessageNotificationListener.class);
    private final IMuleNotificationHandler notificationHandler;

    public DebuggerAsyncMessageNotificationListener(IMuleNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void onNotification(Notification notification) {
        if (notification instanceof AsyncMessageNotification) {
            AsyncMessageNotification asyncNotification = (AsyncMessageNotification)notification;
            Event event = asyncNotification.getEvent();
            int type = asyncNotification.getAction().getActionId();
            logger.debug("Async notification received, type: {}, correlationId: {}", (Object)type, (Object)event.getCorrelationId());
            if (type == 1901) {
                this.notificationHandler.onPipelineStartReached(() -> ((Event)event).getCorrelationId());
            } else if (type == 1902) {
                this.notificationHandler.onPipelineCompleteReached(() -> ((Event)event).getCorrelationId());
            }
        }
    }
}

