/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.mule.notification;

import com.mulesoft.mule.debugger.handler.IMuleNotificationHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.notification.PipelineMessageNotificationListener;
import org.mule.runtime.core.api.construct.Pipeline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerPipelineMessageNotificationListener
implements PipelineMessageNotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerPipelineMessageNotificationListener.class);
    private final IMuleNotificationHandler notificationHandler;

    DebuggerPipelineMessageNotificationListener(IMuleNotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public void onNotification(Notification notification) {
        Event muleEvent = ((EnrichedServerNotification)notification).getEvent();
        PipelineMessageNotification pipelineMessageNotification = (PipelineMessageNotification)notification;
        if (this.isFlowStartedNotification(pipelineMessageNotification)) {
            logger.debug("Notification {} was received {}", (Object)notification.getAction(), (Object)muleEvent.getContext().getCorrelationId());
            this.notificationHandler.onFlowStarted(() -> ((Event)muleEvent).getCorrelationId());
        }
    }

    private boolean isFlowStartedNotification(PipelineMessageNotification pipelineMessageNotification) {
        return pipelineMessageNotification.getAction().getActionId() == 1801 && ((Pipeline)pipelineMessageNotification.getComponent()).getSource() != null;
    }
}

