/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.remote;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.remote.RemoteDebuggerSession;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDebuggerServer
extends Thread {
    private final int serverPort;
    private final IDebuggerClientConnectionHandler connectionHandler;
    private volatile boolean isStopped = false;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(1);
    private static final Logger logger = LoggerFactory.getLogger(RemoteDebuggerServer.class);

    public RemoteDebuggerServer(int port, IDebuggerClientConnectionHandler connectionHandler) {
        this.serverPort = port;
        this.connectionHandler = connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Server starting at {}", (Object)this.serverPort);
        Socket clientSocket = null;
        try (ServerSocket serverSocket = new ServerSocket(this.serverPort);){
            while (!this.isStopped()) {
                clientSocket = serverSocket.accept();
                this.threadPool.execute(new RemoteDebuggerSession(clientSocket, this.connectionHandler));
            }
        }
        catch (IOException e) {
            logger.error("Cannot open port {}", (Object)this.serverPort, (Object)e);
        }
        finally {
            this.stopServer();
            if (clientSocket != null) {
                try {
                    clientSocket.close();
                }
                catch (IOException e) {
                    logger.error("Error closing client socket", (Throwable)e);
                }
            }
        }
        logger.info("Server stopped");
    }

    private synchronized boolean isStopped() {
        return this.isStopped;
    }

    public void startServer() {
        this.start();
    }

    public void stopServer() {
        this.isStopped = true;
        try {
            this.threadPool.shutdownNow();
        }
        catch (SecurityException e) {
            logger.error("Error shutting down the ExecutorService", (Throwable)e);
        }
    }
}

