/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.remote;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.impl.ClientCommunicationService;
import com.mulesoft.mule.debugger.response.ErrorResponse;
import com.mulesoft.mule.debugger.response.IDebuggerResponse;
import com.mulesoft.mule.debugger.transport.IServerDebuggerProtocol;
import com.mulesoft.mule.debugger.transport.SerializeDebuggerProtocol;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteDebuggerSession
implements Runnable {
    private final Socket clientSocket;
    private final IDebuggerClientConnectionHandler clientConnectionHandler;
    private static final Logger logger = LoggerFactory.getLogger(RemoteDebuggerSession.class);

    public RemoteDebuggerSession(Socket clientSocket, IDebuggerClientConnectionHandler clientConnectionHandler) {
        this.clientSocket = clientSocket;
        this.clientConnectionHandler = clientConnectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (SerializeDebuggerProtocol protocol = null;
             InputStream input = this.clientSocket.getInputStream();
             OutputStream output = this.clientSocket.getOutputStream();){
            protocol = new SerializeDebuggerProtocol(input, output);
            if (!this.clientConnectionHandler.isClientConnected()) {
                this.clientConnectionHandler.connectClient(new ClientCommunicationService((IServerDebuggerProtocol)protocol));
            } else {
                protocol.sendResponse((IDebuggerResponse)new ErrorResponse("I can not attend you right now someone else is already connected. Try later!"));
            }
        }
    }
}

