/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.mule.deployment.ComponentLocatorProvider;
import com.mulesoft.mule.debugger.server.CorrelationIdProvider;
import com.mulesoft.mule.debugger.server.IDebuggerManager;
import com.mulesoft.mule.debugger.server.IExecutionManager;
import com.mulesoft.mule.debugger.server.impl.MuleExecutionManager;
import com.mulesoft.mule.debugger.util.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.api.interception.InterceptionEvent;

public class DebuggerManagerImpl
implements IDebuggerManager {
    private static final String WAITING = "WAITING";
    private final MuleExecutionManager muleExecutionManager;
    private String stepping;
    private AtomicReference<Pair<InterceptionEvent, ? extends IExecutionManager>> debuggingMessage = new AtomicReference();
    private Map<String, BlockingQueue<String>> debuggingMessageQueue = new HashMap<String, BlockingQueue<String>>();
    private ReentrantLock singleProcessor = new ReentrantLock(true);

    public DebuggerManagerImpl(IDebuggerClientConnectionHandler clientConnectionHandler) {
        this.muleExecutionManager = new MuleExecutionManager(this, clientConnectionHandler);
        clientConnectionHandler.addListener(new IDebuggerClientConnectionListener(){

            @Override
            public void onClientConnected() {
            }

            @Override
            public void onClientDisconnected() {
                DebuggerManagerImpl.this.stopAllDebuggingSessions();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDebugging() {
        AtomicReference<Pair<InterceptionEvent, ? extends IExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            if (this.debuggingMessage.get() != null) {
                this.debuggingMessageQueue.remove(((InterceptionEvent)this.debuggingMessage.get().getLeft()).getCorrelationId());
                this.debuggingMessage.set(null);
                this.debuggingMessage.notifyAll();
            }
        }
    }

    @Override
    public void stopAllDebuggingSessions() {
        this.stopDebugging();
    }

    public InterceptionEvent getDebuggingMessage() {
        return this.debuggingMessage.get() == null ? null : (InterceptionEvent)this.debuggingMessage.get().getLeft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebuggingThisMessage(CorrelationIdProvider event) {
        AtomicReference<Pair<InterceptionEvent, ? extends IExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            if (this.debuggingMessage.get() == null) {
                return false;
            }
            return ((InterceptionEvent)this.debuggingMessage.get().getLeft()).getCorrelationId().equals(event.getCorrelationId());
        }
    }

    @Override
    public IExecutionManager getCurrentExecutionManager() {
        return this.debuggingMessage.get() == null ? null : (IExecutionManager)this.debuggingMessage.get().getRight();
    }

    @Override
    public MuleExecutionManager getMuleExecutionManager() {
        return this.muleExecutionManager;
    }

    @Override
    public void startDebugging(InterceptionEvent notification) {
        this.startDebugging(notification, this.muleExecutionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDebugging(InterceptionEvent notification, IExecutionManager executionManager) {
        AtomicReference<Pair<InterceptionEvent, ? extends IExecutionManager>> atomicReference = this.debuggingMessage;
        synchronized (atomicReference) {
            while (!this.isDebuggingThisMessage(() -> ((InterceptionEvent)notification).getCorrelationId()) && !this.debuggingMessage.compareAndSet(null, (Pair<InterceptionEvent, ? extends IExecutionManager>)new Pair((Object)notification, (Object)executionManager))) {
                try {
                    this.debuggingMessage.wait();
                }
                catch (InterruptedException e) {
                    this.stopAllDebuggingSessions();
                }
            }
        }
    }

    public void setLocatorProvider(ComponentLocatorProvider locatorProvider) {
        this.muleExecutionManager.setLocatorProvider(locatorProvider);
    }

    @Override
    public void setStepping(InterceptionEvent interceptionEvent, Boolean stepping) {
        this.singleProcessor.lock();
        try {
            if (stepping == null) {
                this.stepping = WAITING;
            } else {
                this.stepping = Boolean.TRUE.equals(stepping) ? interceptionEvent.getCorrelationId() : null;
                this.debuggingMessageQueue.putIfAbsent(interceptionEvent.getCorrelationId(), new ArrayBlockingQueue(1, true));
                this.debuggingMessageQueue.get(interceptionEvent.getCorrelationId()).poll();
            }
        }
        finally {
            this.singleProcessor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isStepping(CorrelationIdProvider provider) {
        Object object;
        try {
            object = this.debuggingMessageQueue;
            synchronized (object) {
                this.debuggingMessageQueue.putIfAbsent(provider.getCorrelationId(), new ArrayBlockingQueue(1, true));
                this.debuggingMessageQueue.get(provider.getCorrelationId()).put(provider.getCorrelationId());
            }
        }
        catch (InterruptedException e) {
            this.stopAllDebuggingSessions();
            return false;
        }
        this.singleProcessor.lock();
        try {
            object = this.stepping != null && this.stepping.equals(provider.getCorrelationId());
            return object;
        }
        finally {
            this.singleProcessor.unlock();
        }
    }
}

