/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server.impl;

import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionHandler;
import com.mulesoft.mule.debugger.client.IDebuggerClientConnectionListener;
import com.mulesoft.mule.debugger.client.impl.DebuggerClientConnectionHandlerImpl;
import com.mulesoft.mule.debugger.client.impl.DebuggerRequestHandlerImpl;
import com.mulesoft.mule.debugger.handler.IMuleNotificationHandler;
import com.mulesoft.mule.debugger.handler.impl.BreakpointHandler;
import com.mulesoft.mule.debugger.handler.impl.MuleNotificationHandlerImpl;
import com.mulesoft.mule.debugger.mule.deployment.DebuggerDeploymentListenerService;
import com.mulesoft.mule.debugger.remote.RemoteDebuggerServer;
import com.mulesoft.mule.debugger.server.impl.DebuggerManagerImpl;
import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.module.plugin.api.deployment.DeploymentListenerProvider;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerPlugin
implements MulePlugin,
DeploymentListenerProvider {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerPlugin.class);
    private IDebuggerClientConnectionHandler debuggerClientConnectionHandler;
    private RemoteDebuggerServer remoteDebuggerServer;
    private boolean started;
    private DebuggerDeploymentListenerService debuggerDeploymentListenerService;
    private DeploymentService deploymentService;

    public void dispose() {
        this.debuggerClientConnectionHandler = null;
        this.remoteDebuggerServer = null;
        this.deploymentService = null;
        this.debuggerDeploymentListenerService = null;
    }

    public void initialise() {
        this.debuggerClientConnectionHandler = new DebuggerClientConnectionHandlerImpl();
        this.remoteDebuggerServer = new RemoteDebuggerServer(this.getPort(), this.debuggerClientConnectionHandler);
        final BreakpointHandler breakpointHandler = BreakpointHandler.create(this.debuggerClientConnectionHandler);
        final DebuggerManagerImpl actionHandler = new DebuggerManagerImpl(this.debuggerClientConnectionHandler);
        IMuleNotificationHandler notificationHandler = this.getNotificationHandler(breakpointHandler, actionHandler);
        this.debuggerDeploymentListenerService = new DebuggerDeploymentListenerService(notificationHandler);
        actionHandler.setLocatorProvider(this.debuggerDeploymentListenerService);
        this.debuggerClientConnectionHandler.addListener(new IDebuggerClientConnectionListener(){

            @Override
            public void onClientConnected() {
                DebuggerRequestHandlerImpl muleMessageRequestHandler = new DebuggerRequestHandlerImpl(actionHandler, DebuggerPlugin.this.debuggerClientConnectionHandler, breakpointHandler, DebuggerPlugin.this.debuggerDeploymentListenerService);
                DebuggerPlugin.this.debuggerClientConnectionHandler.getClientCommunicationService().setRequestHandler(muleMessageRequestHandler);
            }

            @Override
            public void onClientDisconnected() {
            }
        });
    }

    private IMuleNotificationHandler getNotificationHandler(BreakpointHandler breakpointHandler, DebuggerManagerImpl actionHandler) {
        return new MuleNotificationHandlerImpl(breakpointHandler, actionHandler, this.debuggerClientConnectionHandler);
    }

    private Integer getPort() {
        return Integer.getInteger("mule.debug.port", 6666);
    }

    public void start() {
        if (this.isEnabled()) {
            this.onMuleStart();
            this.started = true;
        } else {
            logger.info("Debugger is disabled. To enable use '-D{}=true'", (Object)"mule.debug.enable");
        }
    }

    private boolean isEnabled() {
        return Boolean.getBoolean("mule.debug.enable");
    }

    public void stop() {
        if (this.started) {
            this.onMuleStop();
            this.started = false;
        }
    }

    private void onMuleStop() {
        this.debuggerClientConnectionHandler.disconnectClient();
        this.remoteDebuggerServer.stopServer();
    }

    private void onMuleStart() {
        final CountDownLatch suspendLatch = new CountDownLatch(1);
        boolean suspend = Boolean.getBoolean("mule.debug.suspend");
        logger.info("Suspend property is {}", (Object)suspend);
        if (suspend) {
            this.debuggerClientConnectionHandler.addListener(new IDebuggerClientConnectionListener(){

                @Override
                public void onClientConnected() {
                    suspendLatch.countDown();
                }

                @Override
                public void onClientDisconnected() {
                }
            });
        }
        this.remoteDebuggerServer.startServer();
        if (suspend) {
            try {
                logger.debug("Waiting for debugger client to connect at {}", (Object)this.getPort());
                suspendLatch.await();
                logger.info("Client connected. Continue with mule launch.");
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for client to connect", (Throwable)e);
            }
        }
        if (this.deploymentService != null) {
            this.debuggerDeploymentListenerService.start(this.deploymentService);
        }
    }

    public void setWorkingDirectory(File file) {
    }

    public boolean isDisabledOnEnvironment() {
        return !this.isEnabled();
    }

    public DeploymentListener getDeploymentListener() {
        return this.debuggerDeploymentListenerService;
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }
}

