/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.debugger.server.impl;

import com.mulesoft.mule.debugger.builder.MuleMessageInfoBuilder;
import com.mulesoft.mule.debugger.server.CorrelationIdProvider;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;

public class MuleDebuggingContext {
    private final ComponentLocation componentLocation;
    private final MuleExpressionLanguage muleExpressionLanguage;
    private final TransformationService transformationService;
    private final InterceptionEvent interceptionEvent;
    private final String appName;
    private final Map<String, ProcessorParameterValue> parameters;

    public MuleDebuggingContext(MuleExpressionLanguage muleExpLanguage, InterceptionEvent interceptionEvent, ComponentLocation componentLocation, String appName, TransformationService transformationService) {
        this(muleExpLanguage, interceptionEvent, componentLocation, appName, transformationService, null);
    }

    public MuleDebuggingContext(MuleExpressionLanguage muleExpLanguage, InterceptionEvent interceptionEvent, ComponentLocation componentLocation, String appName, TransformationService transformationService, Map<String, ProcessorParameterValue> parameters) {
        this.interceptionEvent = interceptionEvent;
        this.appName = appName;
        this.componentLocation = componentLocation;
        this.muleExpressionLanguage = muleExpLanguage;
        this.transformationService = transformationService;
        this.parameters = parameters;
    }

    public TypedValue<?> getPayload() {
        return this.getMessage().getPayload();
    }

    public Message getMessage() {
        return this.interceptionEvent.getMessage();
    }

    public MuleExpressionLanguage getExpressionManager() {
        return this.muleExpressionLanguage;
    }

    public InterceptionEvent getInterceptionEvent() {
        return this.interceptionEvent;
    }

    public CorrelationIdProvider getIdProvider() {
        return () -> ((InterceptionEvent)this.interceptionEvent).getCorrelationId();
    }

    public String getAppName() {
        return this.appName;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public Charset getCharset() {
        return MuleMessageInfoBuilder.calculateCharset(this.getPayload().getDataType());
    }

    public TypedValue evaluateExpression(String script) {
        return this.muleExpressionLanguage.evaluate(script, this.interceptionEvent.asBindingContext());
    }

    public TransformationService getTransformationService() {
        return this.transformationService;
    }

    public Map<String, ProcessorParameterValue> getParameters() {
        return this.parameters == null ? new HashMap() : this.parameters;
    }
}

