/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.util;

import com.mulesoft.connectors.ws.internal.util.WebSocketDecorator;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketBroadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryPolicyHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryPolicyHelper.class);
    private static final Class clsApiRetryPolicyTemplate;
    private static final Method mthBroadcast;
    private static final Method mthReconnect;

    public static CompletableFuture<Void> broadcast(WebSocketBroadcaster broadcaster, Collection<WebSocket> sockets, TypedValue<InputStream> content, BiConsumer<WebSocket, Throwable> errorCallback, RetryPolicyTemplate retryPolicyTemplate, Scheduler reconnectionScheduler) {
        if (mthBroadcast == null) {
            return broadcaster.broadcast(sockets, content, errorCallback, retryPolicyTemplate, reconnectionScheduler);
        }
        try {
            return (CompletableFuture)mthBroadcast.invoke((Object)broadcaster, sockets, content, errorCallback, clsApiRetryPolicyTemplate.cast(retryPolicyTemplate), reconnectionScheduler);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Exception calling 'broadcast' method that uses retry form mule-api instead of mule-core, falling back to original impl", (Throwable)e);
            return broadcaster.broadcast(sockets, content, errorCallback, retryPolicyTemplate, reconnectionScheduler);
        }
    }

    public static CompletableFuture<WebSocket> reconnect(WebSocket webSocket, RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        if (webSocket instanceof WebSocketDecorator) {
            return ((WebSocketDecorator)webSocket).reconnect(retryPolicyTemplate, scheduler);
        }
        if (mthReconnect == null) {
            return webSocket.reconnect(retryPolicyTemplate, scheduler);
        }
        try {
            return (CompletableFuture)mthReconnect.invoke((Object)webSocket, clsApiRetryPolicyTemplate.cast(retryPolicyTemplate), scheduler);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (ClassCastException | IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error("Exception calling 'broadcast' method that uses retry form mule-api instead of mule-core, falling back to original impl", (Throwable)e);
            return webSocket.reconnect(retryPolicyTemplate, scheduler);
        }
    }

    static {
        Class<WebSocketBroadcaster> clsWebSocketBroadcaster = WebSocketBroadcaster.class;
        Class<WebSocket> clsWebSocket = WebSocket.class;
        Class<?> _clsApiRetryPolicyTemplate = null;
        Method _mthBroadcast = null;
        Method _mthReconnect = null;
        try {
            _clsApiRetryPolicyTemplate = Class.forName("org.mule.runtime.api.retry.policy.RetryPolicyTemplate");
            _mthBroadcast = clsWebSocketBroadcaster.getDeclaredMethod("broadcast", Collection.class, TypedValue.class, BiConsumer.class, _clsApiRetryPolicyTemplate, Scheduler.class);
            _mthReconnect = clsWebSocket.getDeclaredMethod("reconnect", _clsApiRetryPolicyTemplate, Scheduler.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            LOGGER.warn("{} configuring RetryPolicyHelper, will use default implementation");
        }
        clsApiRetryPolicyTemplate = _clsApiRetryPolicyTemplate;
        mthBroadcast = _mthBroadcast;
        mthReconnect = _mthReconnect;
    }
}

