/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.distribution.assembly.descriptor;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.mulesoft.mule.distribution.assembly.descriptor.AssemblyEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

@Component(role=ContainerDescriptorHandler.class, hint="assembly-content-descriptor")
public class AssemblyContentDescriptorHandler
implements ContainerDescriptorHandler {
    private static final String ASSEMBLY_DESCRIPTOR_YAML_FILE_NAME = "assembly-descriptor.yaml";
    private final List<AssemblyEntry> entries = new ArrayList<AssemblyEntry>();
    private String descriptorJarName;
    private String descriptorJarDestPath;

    public void finalizeArchiveCreation(Archiver archiver) throws ArchiverException {
        this.checkConfig();
        if (!this.entries.isEmpty()) {
            this.entries.clear();
        }
        archiver.getResources().forEachRemaining(archiveEntry -> {
            if (!archiveEntry.getResource().isDirectory()) {
                this.extractEntryInfo((ArchiveEntry)archiveEntry);
            }
        });
        try {
            File descriptor = Files.createTempFile(this.descriptorJarName, ".tmp", new FileAttribute[0]).toFile();
            descriptor.deleteOnExit();
            File yamlDescriptor = this.createYamlDescriptor(this.entries);
            this.buildDescriptorArchive(yamlDescriptor, descriptor);
            String descriptorDestPath = this.buildDescriptorDestPath(this.entries.get(0).getName());
            archiver.addFile(descriptor, descriptorDestPath);
        }
        catch (IOException e) {
            throw new ArchiverException("Error generating the distribution assembly content descriptor", (Throwable)e);
        }
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) throws ArchiverException {
    }

    public List<String> getVirtualFiles() {
        this.checkConfig();
        return Collections.singletonList(ASSEMBLY_DESCRIPTOR_YAML_FILE_NAME);
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        this.checkConfig();
        return true;
    }

    private void checkConfig() {
        if (this.descriptorJarName == null || this.descriptorJarDestPath == null) {
            throw new IllegalStateException("You must configure descriptorJarName and descriptorJarDestPath in your containerDescriptorHandler declaration.");
        }
    }

    public void setDescriptorJarDestPath(String descriptorJarDestPath) {
        this.descriptorJarDestPath = descriptorJarDestPath;
    }

    public void setDescriptorJarName(String descriptorJarName) {
        this.descriptorJarName = descriptorJarName;
    }

    private void extractEntryInfo(ArchiveEntry archiveEntry) {
        try {
            String sha256 = DigestUtils.sha256Hex((InputStream)archiveEntry.getInputStream());
            this.entries.add(new AssemblyEntry(archiveEntry.getName(), archiveEntry.getResource().getSize(), sha256));
        }
        catch (IOException e) {
            throw new ArchiverException("Error generating the Mule distribution assembly descriptor", (Throwable)e);
        }
    }

    private String buildDescriptorDestPath(String someAssemblyEntry) {
        String assemblyRootDir = someAssemblyEntry.substring(0, someAssemblyEntry.indexOf(File.separator));
        return String.join((CharSequence)File.separator, assemblyRootDir, this.descriptorJarDestPath, this.descriptorJarName);
    }

    private File createYamlDescriptor(List<AssemblyEntry> assemblyEntries) throws IOException {
        File resultYaml = Files.createTempFile(ASSEMBLY_DESCRIPTOR_YAML_FILE_NAME, ".tmp", new FileAttribute[0]).toFile();
        resultYaml.deleteOnExit();
        this.buildYamlObjectMapper().writeValue(resultYaml, assemblyEntries);
        return resultYaml;
    }

    private ObjectMapper buildYamlObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new JavaTimeModule());
    }

    private void buildDescriptorArchive(File yamlDescriptor, File descriptorJar) throws IOException {
        try (JarArchiveOutputStream jarOutStream = new JarArchiveOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(descriptorJar.toPath(), new OpenOption[0])));){
            ZipArchiveEntry entry = jarOutStream.createArchiveEntry(yamlDescriptor, ASSEMBLY_DESCRIPTOR_YAML_FILE_NAME);
            jarOutStream.putArchiveEntry(entry);
            try (BufferedInputStream yamlDescriptorInputStream = new BufferedInputStream(Files.newInputStream(yamlDescriptor.toPath(), new OpenOption[0]));){
                IOUtils.copy((InputStream)yamlDescriptorInputStream, (OutputStream)jarOutStream);
            }
            jarOutStream.closeArchiveEntry();
            jarOutStream.finish();
        }
    }
}

