/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.example.embedded;

import static org.mule.runtime.module.embedded.api.EmbeddedContainer.builder;
import static org.mule.runtime.module.embedded.api.Product.MULE;
import static org.mule.runtime.module.embedded.api.Product.MULE_EE;

import static java.lang.Boolean.getBoolean;
import static java.lang.System.getProperty;

import static org.example.embedded.utils.MavenUtils.createDefaultMavenConfigurationBuilder;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.module.embedded.api.ArtifactConfiguration;
import org.mule.runtime.module.embedded.api.ContainerConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentConfiguration;
import org.mule.runtime.module.embedded.api.DeploymentService;
import org.mule.runtime.module.embedded.api.EmbeddedContainer;
import org.mule.runtime.module.embedded.api.Product;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;

import org.slf4j.Logger;

public class Main {

  private static final Logger LOGGER = getLogger(Main.class);

  private static final String EE = "MULE_EE";

  public static void main(String[] args) throws IOException, URISyntaxException {
    run();
  }

  public static void run() throws IOException, URISyntaxException {
    String runtimeProductString = getProperty("runtimeProduct");
    Product runtimeProduct = MULE;
    if (runtimeProductString != null && runtimeProductString.equals(EE)) {
      runtimeProduct = MULE_EE;
    }

    LOGGER.info("Runtime product: " + runtimeProduct);

    EmbeddedContainer embeddedContainer = builder()
        .muleVersion(getProperty("mule.version"))
        .containerConfiguration(ContainerConfiguration.builder().containerFolder(new File(getProperty("container.folder")))
            .build())
        .mavenConfiguration(createDefaultMavenConfigurationBuilder().build())
        .log4jConfigurationFile(org.example.embedded.Main.class.getClassLoader().getResource("log4j2.xml").toURI())
        .product(runtimeProduct)
        .useIsolation(getBoolean("embedded.run.isolated"))
        .build();

    embeddedContainer.start();
    DeploymentService deploymentService = embeddedContainer.getDeploymentService();
    deploymentService.deployApplication(ArtifactConfiguration.builder()
        .artifactLocation(new File(getProperty("app.location")))
        .deploymentConfiguration(DeploymentConfiguration.builder()
            .build())
        .build());

    // The process running this application will be killed, so no need to undeploy the application and gracefully
    // shutdown everything
  }

}
