/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.EnterpriseLicenseKeyRequest;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.licm.impl.MuleLicenseKey;
import com.mulesoft.licm.impl.MuleLicenseKeyRequest;
import com.mulesoft.licm.impl.MuleLicenseManager;

public final class LicenseManagementFactory {
    public static final String MULE_EE = "mule-ee";
    private static LicenseManagementFactory INSTANCE = new LicenseManagementFactory();

    private LicenseManagementFactory() {
    }

    public static LicenseManagementFactory getInstance() {
        return INSTANCE;
    }

    public synchronized LicenseManager createLicenseManager(String licenseManagerType) throws LicenseKeyException {
        if (licenseManagerType == null) {
            throw new IllegalArgumentException("Missing license manager type!");
        }
        if (licenseManagerType.equalsIgnoreCase(MULE_EE)) {
            return new MuleLicenseManager();
        }
        throw new LicenseKeyException("Unrecognized type!");
    }

    public EnterpriseLicenseKeyRequest createLicenseRequest(String licenseRequestType) throws LicenseKeyException {
        if (licenseRequestType == null) {
            throw new IllegalArgumentException("Missing license key request type!");
        }
        if (!licenseRequestType.equalsIgnoreCase(MULE_EE)) {
            throw new LicenseKeyException("Unrecognized type!");
        }
        MuleLicenseKeyRequest request = new MuleLicenseKeyRequest();
        request.setProduct(MULE_EE);
        return request;
    }

    public EnterpriseLicenseKey createLicenseKey(String licenseKeyType) throws LicenseKeyException {
        if (licenseKeyType == null) {
            throw new IllegalArgumentException("Missing license key type!");
        }
        if (!licenseKeyType.equalsIgnoreCase(MULE_EE)) {
            throw new LicenseKeyException("Unrecognized type!");
        }
        MuleLicenseKey key = new MuleLicenseKey();
        return key;
    }
}

