/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.impl;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.EnterpriseLicenseKeyRequest;
import com.mulesoft.licm.LicenseHelper;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.LicenseManager;
import com.mulesoft.licm.impl.TrueLicenseHelper;
import com.mulesoft.licm.impl.TrueLicenseKeyname;
import com.mulesoft.licm.impl.TrueLicenseSubject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleLicenseManager
implements LicenseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrueLicenseHelper.class);
    private ConcurrentMap<String, EnterpriseLicenseKey> validatedProducts = new ConcurrentHashMap<String, EnterpriseLicenseKey>();
    private Map<String, LicenseHelper> licHelperMap = new HashMap<String, LicenseHelper>();

    @Override
    public EnterpriseLicenseKey create(EnterpriseLicenseKeyRequest request) throws LicenseKeyException {
        if (request == null) {
            throw new IllegalArgumentException("Null license request!");
        }
        return this.getHelper(TrueLicenseSubject.EE_LICENSE_SUBJECT.getValue(), TrueLicenseKeyname.COM_MULESOFT_LICM.getValue()).createLicenseKey(request);
    }

    @Override
    public void install(EnterpriseLicenseKey key) throws LicenseKeyException {
        if (key == null) {
            throw new IllegalArgumentException("Null license key!");
        }
        boolean installed = this.doInstall(key);
        if (!installed) {
            LOGGER.error("Couldn't install license key!");
        }
    }

    private boolean doInstall(EnterpriseLicenseKey key) {
        for (LicenseHelper helper : this.getInstallLicenseHelpers()) {
            try {
                helper.installLicenseKey(key);
                return true;
            }
            catch (LicenseKeyException e) {
                LOGGER.debug("Failed to install the license with subject " + ((TrueLicenseHelper)helper).getLicenseSubject() + " and key " + ((TrueLicenseHelper)helper).getLicmKey());
            }
        }
        return false;
    }

    public Collection<LicenseHelper> getInstallLicenseHelpers() {
        ArrayList<LicenseHelper> licenseHelpers = new ArrayList<LicenseHelper>();
        for (TrueLicenseSubject subject : TrueLicenseSubject.values()) {
            for (TrueLicenseKeyname keyname : TrueLicenseKeyname.values()) {
                licenseHelpers.add(this.getHelper(subject.getValue(), keyname.getValue(), keyname.isFips()));
            }
        }
        return licenseHelpers;
    }

    @Override
    public void unInstall() throws LicenseKeyException {
        for (TrueLicenseSubject subject : TrueLicenseSubject.values()) {
            for (TrueLicenseKeyname keyname : TrueLicenseKeyname.values()) {
                this.getHelper(subject.getValue(), keyname.getValue()).unInstallLicenseKey();
            }
        }
    }

    @Override
    public EnterpriseLicenseKey verify(String productKey, File licenseFile) throws LicenseKeyException {
        if (productKey == null) {
            throw new IllegalArgumentException("Null key type!");
        }
        return this.doVerify(productKey, licenseFile);
    }

    private EnterpriseLicenseKey doVerify(String product, File licenseFile) throws LicenseKeyException {
        LicenseKeyException exception = null;
        Collection<LicenseHelper> licenseHelpers = this.getVerificationHelpers(product);
        for (LicenseHelper helper : licenseHelpers) {
            try {
                return helper.verifyLicenseKey(product, licenseFile);
            }
            catch (LicenseKeyException e) {
                if (exception != null) continue;
                exception = e;
            }
            catch (Throwable e) {
                if (exception != null) continue;
                exception = new LicenseKeyException(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new IllegalStateException("No helper available to verify the licenseKey.");
    }

    @Override
    public EnterpriseLicenseKey validate(String productKey) throws LicenseKeyException {
        if (productKey == null) {
            throw new IllegalArgumentException("Null key type!");
        }
        EnterpriseLicenseKey key = (EnterpriseLicenseKey)this.validatedProducts.get(productKey);
        if (key == null) {
            key = this.doValidate(productKey);
            this.validatedProducts.put(productKey, key);
        }
        return key;
    }

    private EnterpriseLicenseKey doValidate(String product) throws LicenseKeyException {
        LicenseKeyException exception = null;
        Collection<LicenseHelper> licenseHelpers = this.getValidationHelpers(product);
        for (LicenseHelper helper : licenseHelpers) {
            try {
                return helper.validateLicenseKey(product);
            }
            catch (LicenseKeyException e) {
                if (exception != null) continue;
                exception = e;
            }
            catch (Throwable e) {
                if (exception != null) continue;
                exception = new LicenseKeyException(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new IllegalStateException("No helper available to validate the licenseKey.");
    }

    public Collection<LicenseHelper> getVerificationHelpers(String product) {
        ArrayList<LicenseHelper> licenseHelpers = new ArrayList<LicenseHelper>();
        for (TrueLicenseSubject subject : TrueLicenseSubject.values()) {
            for (TrueLicenseKeyname keyname : TrueLicenseKeyname.values()) {
                TrueLicenseHelper trueLicenseHelper = (TrueLicenseHelper)this.getHelper(subject.getValue(), keyname.getValue(), keyname.isFips());
                licenseHelpers.add(trueLicenseHelper);
            }
        }
        return licenseHelpers;
    }

    public Collection<LicenseHelper> getValidationHelpers(String product) {
        ArrayList<LicenseHelper> licenseHelpers = new ArrayList<LicenseHelper>();
        for (TrueLicenseSubject subject : TrueLicenseSubject.values()) {
            for (TrueLicenseKeyname keyname : TrueLicenseKeyname.values()) {
                TrueLicenseHelper trueLicenseHelper = (TrueLicenseHelper)this.getHelper(subject.getValue(), keyname.getValue(), keyname.isFips());
                if (!trueLicenseHelper.islicenseNotNull()) continue;
                licenseHelpers.add(trueLicenseHelper);
            }
        }
        if (licenseHelpers.isEmpty()) {
            TrueLicenseHelper trueLicenseHelper = (TrueLicenseHelper)this.getHelper(TrueLicenseSubject.EE_LICENSE_SUBJECT.getValue(), TrueLicenseKeyname.COM_MULESOFT_LICM.getValue());
            TrueLicenseHelper trueLicenseHelperFips = (TrueLicenseHelper)this.getHelper(TrueLicenseSubject.EE_LICENSE_SUBJECT.getValue(), TrueLicenseKeyname.COM_MULESOURCE_LICM_FIPS.getValue(), true);
            licenseHelpers.add(trueLicenseHelper);
            licenseHelpers.add(trueLicenseHelperFips);
        }
        return licenseHelpers;
    }

    private LicenseHelper getHelper(String licenseSubject, String licmKey) {
        return this.getHelper(licenseSubject, licmKey, false);
    }

    private LicenseHelper getHelper(String licenseSubject, String licmKey, boolean isFips) {
        if (!this.licHelperMap.containsKey(this.getLicenseHelperKey(licenseSubject, licmKey, isFips))) {
            TrueLicenseHelper licenseHelper = new TrueLicenseHelper(licenseSubject, licmKey, isFips);
            this.licHelperMap.put(this.getLicenseHelperKey(licenseSubject, licmKey, isFips), licenseHelper);
            return licenseHelper;
        }
        return this.licHelperMap.get(this.getLicenseHelperKey(licenseSubject, licmKey, isFips));
    }

    private String getLicenseHelperKey(String licenseSubject, String licmKey, boolean isFips) {
        return licenseSubject + "-" + licmKey + "-" + isFips;
    }
}

