/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.licm.propertyset.xml;

import com.mulesoft.licm.propertyset.DeserializationException;
import com.mulesoft.licm.propertyset.PropertySet;
import com.mulesoft.licm.propertyset.SerializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLPropertySet
implements PropertySet {
    private static final String ENCODING_PROPERTIES = "ISO-8859-1";
    public static final String INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static final String PROPERTIES_TYPE = "text";
    private final DocumentBuilderFactory factory;
    private final Map<String, XMLProperty> properties = new LinkedHashMap<String, XMLProperty>();

    public XMLPropertySet() {
        this.factory = DocumentBuilderFactory.newInstance();
    }

    @Override
    public String get(String name) {
        XMLProperty property = this.properties.get(name);
        return property == null ? null : property.getValue();
    }

    @Override
    public void put(String name, String newValue) {
        this.properties.computeIfAbsent(name, key -> new XMLProperty((String)key, PROPERTIES_TYPE, newValue)).setValue(newValue);
    }

    @Override
    public void remove(String name) {
        this.properties.remove(name);
    }

    @Override
    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    public String toString() {
        return this.properties.toString();
    }

    @Override
    public void save(OutputStream outputStream) throws SerializationException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document document = builder.newDocument();
            this.addPropertySetElement(document);
            XMLPropertySet.writeDocument(outputStream, document);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SerializationException("Error trying to save an XMLPropertySet to an OutputStream", e);
        }
    }

    private static void writeDocument(OutputStream outputStream, Document document) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", ENCODING_PROPERTIES);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty(INDENT_AMOUNT, "4");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputStream);
        transformer.transform(source, result);
    }

    private void addPropertySetElement(Document document) {
        Element propertySetElement = document.createElement("property-set");
        document.appendChild(propertySetElement);
        for (XMLProperty xmlProperty : this.properties.values()) {
            XMLPropertySet.addPropertyElement(document, propertySetElement, xmlProperty);
        }
    }

    private static void addPropertyElement(Document document, Element propertySetElement, XMLProperty xmlProperty) {
        Element propertyElement = document.createElement("property");
        propertyElement.setAttribute("key", xmlProperty.getKey());
        propertyElement.setAttribute("type", xmlProperty.getType());
        propertyElement.appendChild(document.createTextNode(xmlProperty.getValue()));
        propertySetElement.appendChild(propertyElement);
    }

    @Override
    public void load(InputStream inputStream) throws DeserializationException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            Element propertySetElement = document.getDocumentElement();
            this.parsePropertySet(propertySetElement);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DeserializationException("Error trying to read an XMLPropertySet from an InputStream", e);
        }
    }

    private void parsePropertySet(Element propertySetElement) {
        NodeList propertyElements = propertySetElement.getElementsByTagName("property");
        for (int i = 0; i < propertyElements.getLength(); ++i) {
            Node propertyNode = propertyElements.item(i);
            if (propertyNode.getNodeType() != 1) continue;
            this.parsePropertyNode((Element)propertyNode);
        }
    }

    private void parsePropertyNode(Element propertyElement) {
        String key = propertyElement.getAttribute("key");
        String type = propertyElement.getAttribute("type");
        if (!PROPERTIES_TYPE.equals(type)) {
            throw new IllegalStateException(String.format("<property /> type must be \"text\", but \"%s\" was found", type));
        }
        String value = propertyElement.getTextContent().trim();
        this.put(key, value);
    }

    public static class XMLProperty {
        private String key;
        private String type;
        private String value;

        XMLProperty(String key, String type, String value) {
            this.key = key;
            this.type = type;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

