/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime;

import com.mulesoft.mule.runtime.module.reboot.FipsBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseCheckBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseInstallBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseUninstallBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseVerifyBootstrapConfigurer;
import com.mulesoft.mule.runtime.module.reboot.license.LicenseVerifyDetailsBootstrapConfigurer;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.mule.runtime.module.boot.internal.BootModuleLayerValidationBootstrapConfigurer;
import org.mule.runtime.module.boot.internal.BootstrapConfigurer;
import org.mule.runtime.module.boot.internal.DefaultMuleContainerFactory;
import org.mule.runtime.module.boot.internal.MuleContainerFactory;
import org.mule.runtime.module.boot.internal.MuleContainerWrapper;
import org.mule.runtime.module.boot.internal.MuleContainerWrapperProvider;
import org.mule.runtime.module.boot.internal.MuleLog4jConfigurer;
import org.mule.runtime.module.boot.internal.SLF4JBridgeHandlerBootstrapConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleContainerBootstrap {
    static final String INSTALL_LICENSE_CMD = "installLicense";
    static final String UNINSTALL_LICENSE_CMD = "unInstallLicense";
    static final String VERIFY_LICENSE_CMD = "verifyLicense";
    static final String VERIFY_LICENSE_DETAILS_CMD = "verifyLicenseDetails";
    public static final String[][] CLI_OPTIONS = new String[][]{{"main", Boolean.TRUE.toString(), "Main Class"}, {"installLicense", Boolean.TRUE.toString(), "Replace current license with new license supplied"}, {"unInstallLicense", Boolean.FALSE.toString(), "Uninstall current license"}, {"verifyLicense", Boolean.FALSE.toString(), "Prints currently installed license details"}, {"verifyLicenseDetails", Boolean.TRUE.toString(), "Prints license supplied details"}, {"version", Boolean.FALSE.toString(), "Show product and version information"}};

    public static void main(String[] args) throws Exception {
        DefaultMuleContainerFactory muleContainerFactory = new DefaultMuleContainerFactory("mule.home", "mule.base");
        MuleContainerWrapper muleContainerWrapper = MuleContainerWrapperProvider.getMuleContainerWrapper();
        MuleContainerBootstrap.bootstrap(muleContainerFactory, muleContainerWrapper, args);
    }

    static void bootstrap(MuleContainerFactory muleContainerFactory, MuleContainerWrapper muleContainerWrapper, String ... args) {
        CommandLine commandLine;
        try {
            commandLine = MuleContainerBootstrap.parseCommandLine(args);
        }
        catch (Exception ex) {
            muleContainerWrapper.haltAndCatchFire(1, ex.getMessage());
            return;
        }
        muleContainerWrapper.addBootstrapConfigurer(new SLF4JBridgeHandlerBootstrapConfigurer());
        muleContainerWrapper.addBootstrapConfigurer(new BootModuleLayerValidationBootstrapConfigurer());
        muleContainerWrapper.addBootstrapConfigurer(MuleContainerBootstrap.createLicenseBootstrapConfigurer(commandLine));
        muleContainerWrapper.addBootstrapConfigurer(new FipsBootstrapConfigurer());
        muleContainerWrapper.addBootstrapConfigurer(new MuleLog4jConfigurer());
        muleContainerWrapper.configureAndStart(muleContainerFactory, commandLine);
    }

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options options = new Options();
        for (String[] element : CLI_OPTIONS) {
            options.addOption(element[0], Boolean.valueOf(element[1]).booleanValue(), element[2]);
        }
        return new BasicParser().parse(options, args, true);
    }

    private static BootstrapConfigurer createLicenseBootstrapConfigurer(CommandLine commandLine) {
        Logger licenseBootstrapLogger = LoggerFactory.getLogger(LicenseBootstrapConfigurer.class);
        if (commandLine.hasOption(INSTALL_LICENSE_CMD)) {
            return new LicenseInstallBootstrapConfigurer(licenseBootstrapLogger, MuleContainerBootstrap.resolveInWorkDir(commandLine, commandLine.getOptionValue(INSTALL_LICENSE_CMD)));
        }
        if (commandLine.hasOption(UNINSTALL_LICENSE_CMD)) {
            return new LicenseUninstallBootstrapConfigurer(licenseBootstrapLogger);
        }
        if (commandLine.hasOption(VERIFY_LICENSE_CMD)) {
            return new LicenseVerifyBootstrapConfigurer(licenseBootstrapLogger);
        }
        if (commandLine.hasOption(VERIFY_LICENSE_DETAILS_CMD)) {
            return new LicenseVerifyDetailsBootstrapConfigurer(licenseBootstrapLogger, MuleContainerBootstrap.resolveInWorkDir(commandLine, commandLine.getOptionValue(VERIFY_LICENSE_DETAILS_CMD)));
        }
        return new LicenseCheckBootstrapConfigurer(licenseBootstrapLogger, true);
    }

    private static Path resolveInWorkDir(CommandLine commandLine, String file) {
        for (String arg : commandLine.getArgs()) {
            if (!arg.startsWith("wrapper.working.dir=")) continue;
            String workingDir = arg.split("=", 2)[1];
            return Paths.get(workingDir, new String[0]).resolve(file).normalize();
        }
        return Paths.get(file, new String[0]);
    }
}

