/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.jms;

import com.mulesoft.mule.runtime.bti.api.jms.JmsConnectionConfig;
import com.mulesoft.mule.runtime.bti.internal.jms.AbstractConnectionFactoryDecorator;
import com.mulesoft.mule.runtime.bti.internal.jms.BitronixConnectionFactoryWrapper;
import com.mulesoft.mule.runtime.bti.internal.transaction.MuleTransactionManager;
import jakarta.transaction.TransactionManager;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BitronixConnectionFactoryDecorator
extends AbstractConnectionFactoryDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitronixConnectionFactoryDecorator.class);

    @Override
    protected ConnectionFactory doDecorate(ConnectionFactory connectionFactory, JmsConnectionConfig jmsConfig, MuleConfiguration muleConfiguration, TransactionManager txManager) {
        if (!this.isConnectionFactoryWrapper(connectionFactory) && this.isXaConnectionFactory(connectionFactory)) {
            LOGGER.info("No pool defined for XAConnectionFactory in connector {}. A default pool will be created. To customize define a bti:xa-caching-connection-factory element in your config and assign it to the connector.", (Object)jmsConfig.getName());
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = new BitronixConnectionFactoryWrapper();
            connectionFactoryWrapper.setMuleConfiguration(muleConfiguration);
            connectionFactoryWrapper.setTxManager(txManager);
            connectionFactoryWrapper.setConnectionFactory((XAConnectionFactory)((Object)connectionFactory));
            connectionFactoryWrapper.setName(jmsConfig.getName());
            connectionFactoryWrapper.setUsername(jmsConfig.getUsername());
            connectionFactoryWrapper.setPassword(jmsConfig.getPassword());
            connectionFactoryWrapper.setMaxIdleTime(jmsConfig.getMaxIdleTime());
            connectionFactoryWrapper.setMinPoolSize(jmsConfig.getMinPoolSize());
            connectionFactoryWrapper.setMaxPoolSize(jmsConfig.getMaxPoolSize());
            return connectionFactoryWrapper;
        }
        if (this.isConnectionFactoryWrapper(connectionFactory)) {
            BitronixConnectionFactoryWrapper connectionFactoryWrapper = (BitronixConnectionFactoryWrapper)connectionFactory;
            connectionFactoryWrapper.setUsername(jmsConfig.getUsername());
            connectionFactoryWrapper.setPassword(jmsConfig.getPassword());
        }
        return connectionFactory;
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return this.appliesTo(connectionFactory);
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory) {
        return this.appliesTo(connectionFactory, this.getTxManager());
    }

    private boolean appliesTo(ConnectionFactory connectionFactory, TransactionManager txManager) {
        return this.isBitronixTxManager(txManager) && (this.isConnectionFactoryWrapper(connectionFactory) || this.isXaConnectionFactory(connectionFactory));
    }

    private boolean isBitronixTxManager(TransactionManager txManager) {
        return txManager instanceof MuleTransactionManager;
    }
}

