/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.messaging;

import bitronix.tm.resource.messaging.DualSessionWrapper;
import bitronix.tm.resource.messaging.MessagingConnectionHandle;
import com.mulesoft.mule.runtime.bti.internal.messaging.BitronixSessionInvocationHandler;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.proxy.TargetInvocationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixConnectionInvocationHandler
implements TargetInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(BitronixConnectionInvocationHandler.class);
    private Connection connection;

    public BitronixConnectionInvocationHandler(Connection connecton) {
        this.connection = connecton;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking {}", (Object)method);
        }
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (method.getName().equals("createSession")) {
            if (tx != null) {
                DualSessionWrapper xas = (DualSessionWrapper)this.connection.createSession(((Boolean)args[0]).booleanValue(), ((Integer)args[1]).intValue());
                return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Session.class, MuleXaObject.class}, (InvocationHandler)new BitronixSessionInvocationHandler(xas));
            }
            return this.connection.createSession(false, 1);
        }
        if (method.getName().equals("getHoldObject")) {
            return this.connection;
        }
        return method.invoke((Object)this.connection, args);
    }

    @Override
    public Object getTargetObject() {
        block3: {
            Connection connection = this.connection;
            if (connection instanceof MessagingConnectionHandle) {
                MessagingConnectionHandle messagingConnectionHandle = (MessagingConnectionHandle)connection;
                try {
                    return messagingConnectionHandle.getXAConnection();
                }
                catch (JMSException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Failed to get XA connection", (Throwable)e);
                }
            }
        }
        return this.connection;
    }
}

