/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.bti.internal.transaction;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.XAResourceProducer;
import com.mulesoft.mule.runtime.bti.api.util.BitronixConfigurationUtil;
import com.mulesoft.mule.runtime.bti.internal.transaction.TransactionManagerWrapper;
import com.mulesoft.mule.runtime.bti.internal.xa.QueueManagerXaResourceProducer;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.transaction.TransactionManager;
import java.util.function.Supplier;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.transaction.TransactionManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitronixTransactionManagerFactory
extends AbstractComponent
implements TransactionManagerFactory,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitronixTransactionManagerFactory.class);
    private static int numberOfAppsUsingTm;
    private static TransactionManager transactionManager;
    private static QueueManagerXaResourceProducer defaultXaSessionResourceProducer;
    private final LazyValue<BitronixTransactionManager> btiTransactionManagerSupplier = new LazyValue<Supplier<BitronixTransactionManager>>(TransactionManagerServices::getTransactionManager);
    private boolean transactionManagerUsedByThisApp;
    private QueueManager queueManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager create(MuleConfiguration config) throws Exception {
        Class<BitronixTransactionManagerFactory> clazz = BitronixTransactionManagerFactory.class;
        synchronized (BitronixTransactionManagerFactory.class) {
            if (transactionManager == null) {
                this.configureTransactionLogsDirectory();
                this.configureUniqueServerId();
                this.configureTransactionRecoveryExecutionInterval();
                this.configureTransactionTimeout();
                this.registerMuleQueuesXaResource();
                transactionManager = new TransactionManagerWrapper(this.btiTransactionManagerSupplier, defaultXaSessionResourceProducer);
            }
            if (!this.transactionManagerUsedByThisApp) {
                this.transactionManagerUsedByThisApp = true;
                ++numberOfAppsUsingTm;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return transactionManager;
        }
    }

    private void configureTransactionTimeout() {
        TransactionManagerServices.getConfiguration().setDefaultTransactionTimeout(BitronixConfigurationUtil.getTransactionTimeout());
    }

    private void configureTransactionRecoveryExecutionInterval() {
        int transactionRecoveryIntervalInSeconds = BitronixConfigurationUtil.getTransactionRecoveryIntervalInSeconds();
        LOGGER.info("Using {} seconds for recovery interval", (Object)transactionRecoveryIntervalInSeconds);
        TransactionManagerServices.getConfiguration().setBackgroundRecoveryIntervalSeconds(transactionRecoveryIntervalInSeconds);
    }

    private void registerMuleQueuesXaResource() throws RecoveryException {
        String defaultXaSessionUniqueName = BitronixConfigurationUtil.createUniqueIdForServer() + "-default-xa-session";
        defaultXaSessionResourceProducer = new QueueManagerXaResourceProducer(this.queueManager, defaultXaSessionUniqueName);
        ResourceRegistrar.register((XAResourceProducer)defaultXaSessionResourceProducer);
    }

    private void configureUniqueServerId() {
        String uniqueServerId = BitronixConfigurationUtil.createUniqueIdForServer();
        LOGGER.info("Bitronix server id: {}", (Object)uniqueServerId);
        TransactionManagerServices.getConfiguration().setServerId(uniqueServerId);
    }

    private void configureTransactionLogsDirectory() {
        String logPart1Filename = BitronixConfigurationUtil.getLogPart1Filename();
        String logPart2Filename = BitronixConfigurationUtil.getLogPart2Filename();
        LOGGER.info("Using log file {} for tx log part 1", (Object)logPart1Filename);
        LOGGER.info("Using log file {} for tx log part 2", (Object)logPart2Filename);
        TransactionManagerServices.getConfiguration().setLogPart1Filename(logPart1Filename);
        TransactionManagerServices.getConfiguration().setLogPart2Filename(logPart2Filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dispose() {
        try {
            if (!this.transactionManagerUsedByThisApp) return;
            Class<BitronixTransactionManagerFactory> clazz = BitronixTransactionManagerFactory.class;
            synchronized (BitronixTransactionManagerFactory.class) {
                this.transactionManagerUsedByThisApp = false;
                if (--numberOfAppsUsingTm != 0) return;
                transactionManager = null;
                defaultXaSessionResourceProducer.close();
                this.btiTransactionManagerSupplier.get().shutdown();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failure shutting down transaction manager: {}", (Object)e.getMessage());
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Inject
    @Named(value="_muleQueueManager")
    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }
}

