/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.cache.internal;

import com.mulesoft.mule.runtime.cache.api.InvalidatableCachingStrategy;
import com.mulesoft.mule.runtime.cache.api.InvalidateCacheException;
import com.mulesoft.mule.runtime.cache.internal.AbstractCachingStrategy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;

public class ObjectStoreCachingStrategy
extends AbstractCachingStrategy
implements InvalidatableCachingStrategy,
Lifecycle {
    public static final String OBJECT_STORE_SUFFIX = ".store";
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    private ObjectStore<CoreEvent> store;
    private ObjectStore<CoreEvent> privateStore;
    private boolean storeSet;
    private String name;
    private boolean persistent;
    private int entryTTL;
    private int maxEntries;
    private int expirationInterval;
    private boolean isOwnedObjectStore;

    public ObjectStore<CoreEvent> getObjectStore() {
        return this.store;
    }

    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.name = name;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setEntryTTL(int entryTTL) {
        this.entryTTL = entryTTL;
    }

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setExpirationInterval(int expirationInterval) {
        this.expirationInterval = expirationInterval;
    }

    public void setObjectStore(ObjectStore<CoreEvent> store) {
        this.storeSet = true;
        this.store = store;
    }

    public void setPrivateObjectStore(ObjectStore<CoreEvent> privateObjectStore) {
        this.privateStore = privateObjectStore;
    }

    private ObjectStore<CoreEvent> createImplicitObjectStore() {
        return this.objectStoreManager.getOrCreateObjectStore(this.name + OBJECT_STORE_SUFFIX, ObjectStoreSettings.builder().persistent(this.persistent).maxEntries(this.maxEntries).entryTtl(Long.valueOf(this.entryTTL)).expirationInterval(Long.valueOf(this.expirationInterval)).build());
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        boolean bl = this.isOwnedObjectStore = this.privateStore != null || this.store == null;
        if (this.store != null && this.privateStore != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Ambiguous definition of object store, both reference and private were configured"), (Initialisable)this);
        }
        if (this.privateStore != null) {
            this.store = this.privateStore;
        }
        if (this.store == null) {
            this.store = this.createImplicitObjectStore();
        }
        if (this.isOwnedObjectStore) {
            LifecycleUtils.initialiseIfNeeded(this.store, true, this.muleContext);
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.isOwnedObjectStore) {
            LifecycleUtils.startIfNeeded(this.store);
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.isOwnedObjectStore) {
            LifecycleUtils.stopIfNeeded(this.store);
        }
        super.stop();
    }

    @Override
    public void dispose() {
        if (this.isOwnedObjectStore) {
            LifecycleUtils.disposeIfNeeded(this.store, this.logger);
        }
    }

    @Override
    protected void store(String key, CoreEvent value) {
        try {
            this.store.store(key, value);
        }
        catch (ObjectAlreadyExistsException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("An object with the specified key already exists in the object store (" + key + ")");
            }
        }
        catch (ObjectStoreException e) {
            this.logger.warn("Unable to store event in cache", (Throwable)e);
        }
    }

    @Override
    protected CoreEvent retrieve(String key) {
        try {
            return this.store.retrieve(key);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
        }
        catch (ObjectStoreException e) {
            this.logger.warn("Unable to retrieve object from cache", (Throwable)e);
        }
        catch (RuntimeException e) {
            this.logger.warn("Unable to retrieve object from cache. Verify if there is a serialization compatibility problem", (Throwable)e);
            this.tryInvalidate(key);
        }
        return null;
    }

    @Override
    public void invalidate() {
        this.getKeys(this.store).forEach(this::invalidate);
    }

    private void tryInvalidate(String key) {
        try {
            this.invalidate(key);
        }
        catch (InvalidateCacheException e) {
            this.logger.warn("Error invalidating key", (Throwable)e);
        }
    }

    private List<String> getKeys(ObjectStore ObjectStore2) {
        try {
            return ObjectStore2.allKeys();
        }
        catch (ObjectStoreException e) {
            throw new InvalidateCacheException("Unable to invalidate cache", e);
        }
    }

    @Override
    public void invalidate(String key) {
        Lock lock = this.getLock((Serializable)((Object)key));
        lock.lock();
        try {
            this.store.remove(key);
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
        }
        catch (ObjectStoreException e) {
            throw new InvalidateCacheException("Error invalidating key", e);
        }
        finally {
            lock.unlock();
        }
    }
}

