/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.config.license;

import com.mulesoft.mule.runtime.core.api.util.license.LicenseKey;
import com.mulesoft.mule.runtime.core.api.util.license.LicenseUtils;
import com.mulesoft.mule.runtime.core.api.util.license.MuleLicenseException;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.internal.util.ClassUtils;

public class MuleEmbeddedLicenseCheck {
    private static final boolean DIET_MODE = System.getProperty("mule.diet.gateway.mode") != null;
    private static LazyValue<LicenseKey> LICENSE_KEY = new LazyValue<Supplier<LicenseKey>>(() -> {
        try {
            return LicenseUtils.getLicenseKey("mule-ee");
        }
        catch (MuleLicenseException e) {
            throw new MuleRuntimeException(e);
        }
    });

    public static void checkLicense() {
        if (!DIET_MODE) {
            LICENSE_KEY.get();
        }
    }

    public static void checkLicense(ClassLoader callerClassLoader) {
        ClassUtils.withContextClassLoader(callerClassLoader, () -> {
            try {
                callerClassLoader.loadClass("com.mulesoft.licm.LicenseManager");
            }
            catch (Throwable e) {
                throw new IllegalStateException("Failed to validate Mule EE license: no license manager found");
            }
            MuleEmbeddedLicenseCheck.checkLicense();
        });
    }
}

