/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.processor;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;

@NoInstantiate
public final class DynamicEvaluateProcessorParameters
extends AbstractComponent
implements Initialisable {
    @Inject
    private ExtendedExpressionManager expressionManager;
    private final AttributeEvaluator parameters;

    public DynamicEvaluateProcessorParameters(String parameters) {
        DataType outputType = DataType.builder().mapType(HashMap.class).keyType(String.class).valueType(TypedValue.class).build();
        this.parameters = new AttributeEvaluator(parameters, outputType);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.parameters.getRawValue() != null) {
            this.parameters.initialize(this.expressionManager);
            Preconditions.checkArgument(this.expressionManager.isExpression(this.parameters.getRawValue()), "The 'parameters' must be provided through an expression.");
        }
    }

    BindingContext toBindingContext(CoreEvent event) {
        if (this.parameters.getRawValue() == null) {
            return BindingContextUtils.NULL_BINDING_CONTEXT;
        }
        Map bindings = (Map)this.parameters.resolveValue(event);
        BindingContext.Builder builder = BindingContext.builder();
        if (bindings == null) {
            throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage("Parameters evaluated to 'null'."));
        }
        bindings.forEach(builder::addBinding);
        return builder.build();
    }
}

