/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.buffer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.AbstractRecordBuffer;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InMemoryRecordBuffer
extends AbstractRecordBuffer {
    private static Logger LOGGER = LoggerFactory.getLogger(InMemoryRecordBuffer.class);
    private final int size;
    private final Cache<BatchJobInstanceAdapter, BufferHolder> holders;

    public InMemoryRecordBuffer(String name, int size) {
        super(name);
        this.size = size;
        this.holders = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    }

    protected abstract void doFlush(BatchJobInstanceAdapter var1, Multimap<BatchTransactionContext, Record> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(BatchJobInstanceAdapter jobInstance) {
        BufferHolder holder = this.getHolder(jobInstance);
        Multimap<BatchTransactionContext, Record> multimap = holder.items;
        synchronized (multimap) {
            if (!holder.items.isEmpty()) {
                ImmutableMultimap items = ImmutableMultimap.copyOf(holder.items);
                holder.items.clear();
                this.doFlush(jobInstance, (Multimap<BatchTransactionContext, Record>)items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushAndForget(BatchJobInstanceAdapter jobInstance) {
        Cache<BatchJobInstanceAdapter, BufferHolder> cache = this.holders;
        synchronized (cache) {
            this.flush(jobInstance);
            this.forget(jobInstance);
        }
    }

    @Override
    public void forget(BatchJobInstanceAdapter jobInstance) {
        this.removeHolder(jobInstance);
    }

    protected Object getHolderLock() {
        return this.holders;
    }

    @Override
    public int add(BatchJobInstanceAdapter jobInstance, BatchTransactionContext ctx, Record record) {
        record.getCompletionCallback().incrementConsumers();
        return this.getHolder(jobInstance).add(record, ctx);
    }

    @Override
    public long size(BatchJobInstanceAdapter jobInstance) {
        return this.getHolder(jobInstance).size();
    }

    private void removeHolder(BatchJobInstanceAdapter jobInstance) {
        this.holders.invalidate((Object)jobInstance);
    }

    private BufferHolder getHolder(BatchJobInstanceAdapter jobInstance) {
        try {
            return (BufferHolder)this.holders.get((Object)jobInstance, () -> new BufferHolder(jobInstance, this.size));
        }
        catch (ExecutionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Found exception trying to buffer record from instance '%s' of job '%s' on buffer '%s'", jobInstance.getId(), jobInstance.getOwnerJobName(), this.getName())), (Throwable)e);
        }
    }

    private class BufferHolder {
        private final BatchJobInstanceAdapter jobInstance;
        private final Multimap<BatchTransactionContext, Record> items = ArrayListMultimap.create();
        private final int size;

        private BufferHolder(BatchJobInstanceAdapter jobInstance, int size) {
            this.jobInstance = jobInstance;
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add(Record item, BatchTransactionContext ctx) {
            int retVal;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding record to buffer " + InMemoryRecordBuffer.this.getName());
            }
            ArrayListMultimap flusheable = null;
            Multimap<BatchTransactionContext, Record> multimap = this.items;
            synchronized (multimap) {
                this.items.put((Object)ctx, (Object)item);
                if (this.items.size() == this.size) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(String.format("buffer %s has reached %d elements and will be flushed", InMemoryRecordBuffer.this.getName(), this.size));
                    }
                    flusheable = ArrayListMultimap.create(this.items);
                    this.items.clear();
                }
                retVal = this.items.size();
            }
            if (flusheable != null) {
                InMemoryRecordBuffer.this.doFlush(this.jobInstance, (Multimap<BatchTransactionContext, Record>)flusheable);
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long size() {
            Multimap<BatchTransactionContext, Record> multimap = this.items;
            synchronized (multimap) {
                return this.items.size();
            }
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass().equals(BufferHolder.class)) {
                BufferHolder other = (BufferHolder)obj;
                return this.jobInstance.equals(other.jobInstance);
            }
            return false;
        }

        public int hashCode() {
            return this.jobInstance.hashCode();
        }
    }
}

