/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.engine.history;

import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobInstance;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceStore;
import com.mulesoft.mule.runtime.module.batch.engine.history.HistoryExpirationPolicy;
import com.mulesoft.mule.runtime.module.batch.internal.engine.history.HistoryExpirationMonitor;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.Closeable;
import org.mule.runtime.core.api.MuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryExpirationMonitor
implements HistoryExpirationMonitor,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHistoryExpirationMonitor.class);
    private final BatchEngine batchEngine;
    private final BatchJobInstanceStore store;
    private final long frequency;
    private final TimeUnit timeUnit;
    private final MuleContext muleContext;
    private Scheduler scheduler;

    public DefaultHistoryExpirationMonitor(BatchEngine batchEngine, BatchJobInstanceStore store, long frequency, TimeUnit timeUnit, MuleContext muleContext) {
        this.batchEngine = batchEngine;
        this.store = store;
        this.frequency = frequency;
        this.timeUnit = timeUnit;
        this.muleContext = muleContext;
    }

    @Override
    public void beginMonitoring() {
        this.scheduler = this.muleContext.getSchedulerService().ioScheduler(this.muleContext.getSchedulerBaseConfig().withName("batch.history.expiration.monitor"));
        this.scheduler.scheduleWithFixedDelay(this, this.frequency, this.frequency, this.timeUnit);
        LOGGER.debug(this.toString() + " started.");
    }

    @Override
    public void run() {
        if (this.isStoppedOrStopping()) {
            return;
        }
        LOGGER.debug("Starting batch history expiration cycle");
        try {
            for (BatchJob job : this.batchEngine.getBatchJobs()) {
                this.expireJobHistory((BatchJobAdapter)job);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception found processing batch history expiration", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireJobHistory(BatchJobAdapter job) {
        if (this.isStoppedOrStopping()) {
            return;
        }
        LOGGER.debug("Processing batch history expiration cycle for job '{}'", (Object)job.getName());
        Iterator jobInstances = null;
        HistoryExpirationPolicy policy = job.getHistoryExpirationPolicy();
        try {
            jobInstances = this.store.getJobInstances(job.getName());
            while (jobInstances.hasNext()) {
                this.expireJobInstanceHistory((BatchJobInstance)jobInstances.next(), policy);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception found expiring history for job '" + job.getName() + "'", (Throwable)e);
        }
        finally {
            try {
                if (jobInstances instanceof Closeable) {
                    ((Closeable)((Object)jobInstances)).close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception found closing the instances iterator for job '" + job.getName() + "'", (Throwable)e);
            }
        }
    }

    private void expireJobInstanceHistory(BatchJobInstance jobInstance, HistoryExpirationPolicy policy) {
        try {
            if (policy.shouldExpire(jobInstance)) {
                LOGGER.debug("Expiring history for instance {} of job '{}'", (Object)jobInstance.getId(), (Object)jobInstance.getOwnerJobName());
                this.store.remove(jobInstance);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception found expiring history for instance {} of job '{}'", (Object)jobInstance.getId(), (Object)jobInstance.getOwnerJobName());
        }
    }

    @Override
    public void stopMonitoring() {
        this.scheduler.stop();
    }

    private boolean isStoppedOrStopping() {
        return this.muleContext.isStopping() || this.muleContext.isStopped();
    }

    public String toString() {
        return "DefaultHistoryExpirationMonitor(" + this.muleContext.getConfiguration().getId() + "_batch.history.expiration.monitor)";
    }
}

