/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal.reporting;

import com.mulesoft.mule.runtime.module.batch.api.BatchJob;
import com.mulesoft.mule.runtime.module.batch.api.BatchStep;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchJobResult;
import com.mulesoft.mule.runtime.module.batch.api.extension.structure.BatchStepResult;
import com.mulesoft.mule.runtime.module.batch.internal.reporting.BatchResultReporter;
import com.mulesoft.mule.runtime.module.batch.internal.reporting.SimpleLoggingTable;
import java.util.Map;

public class ExceptionsInTextBatchResultReporter
implements BatchResultReporter<String> {
    @Override
    public String buildReport(BatchJob job, BatchJobResult jobResult) {
        if (jobResult.getFailedRecords() == 0L) {
            return "";
        }
        SimpleLoggingTable table = new SimpleLoggingTable();
        table.addColumn("Exception Type", 50);
        table.addColumn("Step", 50);
        table.addColumn("Count", 50);
        for (BatchStep step : job.getSteps()) {
            BatchStepResult stepResult = jobResult.getResultForStep(step.getName());
            for (Map.Entry<Class<? extends Exception>, Long> entry : stepResult.getExceptionSummary().getExceptionsCount().entrySet()) {
                table.addDataRow(new String[]{entry.getKey().getName(), step.getName(), entry.getValue().toString()});
            }
        }
        return table.toString();
    }
}

