/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.boot.license.internal;

import com.mulesoft.licm.EnterpriseLicenseKey;
import com.mulesoft.licm.LicenseKeyException;
import com.mulesoft.licm.feature.Feature;
import com.mulesoft.licm.feature.FeatureValidator;
import com.mulesoft.mule.runtime.module.boot.license.LicenseKey;
import com.mulesoft.mule.runtime.module.boot.license.MuleLicenseException;
import java.util.Date;

public class DefaultLicenseKey
implements LicenseKey {
    private final EnterpriseLicenseKey license;

    public DefaultLicenseKey(EnterpriseLicenseKey license) {
        this.license = license;
    }

    @Override
    public boolean hasEntitlement(String id, String name) {
        try {
            this.validateFeature(id, name);
            return true;
        }
        catch (MuleLicenseException e) {
            return false;
        }
    }

    @Override
    public void validateFeature(String featureId, String featureName) throws MuleLicenseException {
        if (!this.isEvaluationLicense()) {
            try {
                new FeatureValidator(new Feature(featureId, featureName)).validate(this.license);
            }
            catch (LicenseKeyException e) {
                throw new MuleLicenseException(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean isEvaluationLicense() {
        return this.license.isEvaluation();
    }

    @Override
    public Date getExpirationDate() {
        return this.license.getExpirationDate();
    }

    public String toString() {
        return this.license.toString();
    }
}

