/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterLocker;
import com.mulesoft.mule.runtime.module.cluster.api.ClusterManager;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.api.map.ClusterMap;
import com.mulesoft.mule.runtime.module.cluster.api.notification.PrimaryClusterNodeListener;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClientInstanceBuilder;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterLocker;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastObjectStore;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastPartitionLogger;
import com.mulesoft.mule.runtime.module.cluster.internal.MuleHazelcastInstanceFactory;
import com.mulesoft.mule.runtime.module.cluster.internal.boot.notification.CompositePrimaryClusterNodeNotifier;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClasspathXmlHazelcastConfig;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterConfigLogger;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterTicketFileLoader;
import com.mulesoft.mule.runtime.module.cluster.internal.config.HazelcastPropertiesConfig;
import com.mulesoft.mule.runtime.module.cluster.internal.config.HazelcastUtils;
import com.mulesoft.mule.runtime.module.cluster.internal.config.PerformanceStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ReliableStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.config.SystemPropertiesConfigLoader;
import com.mulesoft.mule.runtime.module.cluster.internal.map.HazelcastClusterMap;
import com.mulesoft.mule.runtime.module.cluster.internal.serialization.ClusterDistributedObjectSerializer;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastClusterManager
implements ClusterManager {
    private static final String HAZELCAST_HEARTBEAT_TIMEOUT_KEY = "hazelcast.max.no.heartbeat.seconds";
    private static final int HAZELCAST_DEFAULT_HEARTBEAT_TIMEOUT_SECS = 500;
    private static final int LOCKER_THREAD_DISPOSE_TIMEOUT = 500;
    private static final String HAZELCAST_DEFAULT_CONFIG_FILE_NAME = "hazelcast.xml";
    private static final String HAZELCAST_CONFIG_FILE_PROP = "mule.cluster.configfile";
    private static final Logger logger = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final ClusterConfigLogger hazelcastConfigLogger = new ClusterConfigLogger();
    public static final String ERROR_MESSAGE_CREATING_MANAGER = "Error while creating the cluster manager";
    private final Properties clusterConfigProperties;
    private HazelcastInstance hazelcastInstance;
    private List<HazelcastObjectStore> hazelcastObjectStores = new LinkedList<HazelcastObjectStore>();
    protected String clusterId;
    private String clusterNodeId;
    private volatile boolean isPoller;
    private CompositePrimaryClusterNodeNotifier clusterPrimaryNodeNotifier;
    private HazelcastClusterLocker primaryNodePollingThread;
    private ClusterStoreProfile defaultClusterStoreProfile = new ReliableStoreProfile();
    private final ConcurrentHashMap<String, ClusterMap> clusterMaps = new ConcurrentHashMap();

    HazelcastClusterManager(ClassLoaderRepository classLoaderRepository) {
        ClusterTicketFileLoader clusterTicketFileLoader = new ClusterTicketFileLoader();
        SystemPropertiesConfigLoader systemPropertiesConfigLoader = new SystemPropertiesConfigLoader();
        Properties clusterTicketFileProperties = clusterTicketFileLoader.load();
        Properties clusterSystemPropertiesProperties = systemPropertiesConfigLoader.load();
        this.clusterConfigProperties = new Properties();
        this.clusterConfigProperties.putAll((Map<?, ?>)clusterTicketFileProperties);
        this.clusterConfigProperties.putAll((Map<?, ?>)clusterSystemPropertiesProperties);
        if (this.clusterConfigProperties.getProperty("mule.clusterId") == null) {
            throw new IllegalArgumentException("instance cannot be created since there's no cluster configuration");
        }
        if (this.clusterConfigProperties.getProperty("mule.clusterNodeId") == null) {
            int clusterNodeId = Math.abs(new Random(System.currentTimeMillis()).nextInt());
            this.clusterConfigProperties.put("mule.clusterNodeId", (Object)clusterNodeId);
        }
        System.setProperty("hazelcast.logging.type", "slf4j");
        if (this.isClientModeEnabled()) {
            this.configureClientMode();
        } else {
            this.configureServerMode(classLoaderRepository);
        }
    }

    public Properties getClusterConfigProperties() {
        return this.clusterConfigProperties;
    }

    private void configureServerMode(ClassLoaderRepository classLoaderRepository) {
        String hazelcastConfigFile = this.clusterConfigProperties.getProperty(HAZELCAST_CONFIG_FILE_PROP, HAZELCAST_DEFAULT_CONFIG_FILE_NAME);
        Config hazelcastConfig = new Config();
        hazelcastConfig.setClassLoader(this.getClass().getClassLoader());
        hazelcastConfig.getProperties().put(ClassLoaderRepository.class.getName(), classLoaderRepository);
        URL hazelcastConfigResource = HazelcastClusterManager.class.getClassLoader().getResource(hazelcastConfigFile);
        if (hazelcastConfigResource != null) {
            hazelcastConfig = new ClasspathXmlHazelcastConfig(hazelcastConfigFile).createConfig(hazelcastConfig);
            String nodeId = this.clusterConfigProperties.getProperty("mule.clusterNodeId");
            hazelcastConfig.setInstanceName(nodeId);
        } else {
            boolean multicastExplicit = this.clusterConfigProperties.getProperty("mule.cluster.multicastenabled") != null;
            boolean multicastEnabled = Boolean.parseBoolean(this.clusterConfigProperties.getProperty("mule.cluster.multicastenabled"));
            String discoverySpiMechanism = this.clusterConfigProperties.getProperty("mule.cluster.discoverymechanism");
            String clusterNodes = this.clusterConfigProperties.getProperty("mule.cluster.nodes");
            Preconditions.checkArgument(this.clusterConfigProperties.getProperty("mule.clusterId") != null, "No cluster ID was specified.");
            Preconditions.checkState(this.isClusterStrategyEnabled(multicastExplicit, multicastEnabled, clusterNodes, discoverySpiMechanism), "Either enable Multicast or specify node IPs or enable Discovery SPI.");
            Preconditions.checkState(this.isUniqueClusterStrategy(multicastExplicit, multicastEnabled, clusterNodes, discoverySpiMechanism), "You can't enable Multicast and specify cluster nodes IPs and enable discovery SPI at the same time.");
            hazelcastConfig = new HazelcastPropertiesConfig(this.clusterConfigProperties).createConfig(hazelcastConfig);
            String globalStoreProfile = this.clusterConfigProperties.getProperty("mule.cluster.storeprofile");
            if ("performance".equalsIgnoreCase(globalStoreProfile)) {
                this.defaultClusterStoreProfile = new PerformanceStoreProfile();
            }
        }
        ClusterDistributedObjectSerializer.configureInto(hazelcastConfig);
        hazelcastConfigLogger.log(hazelcastConfig);
        this.clusterId = hazelcastConfig.getClusterName();
        this.clusterNodeId = hazelcastConfig.getInstanceName();
        this.hazelcastInstance = Hazelcast.getHazelcastInstanceByName((String)hazelcastConfig.getInstanceName());
        if (this.hazelcastInstance == null) {
            this.hazelcastInstance = MuleHazelcastInstanceFactory.newHazelcastInstance(hazelcastConfig);
            this.hazelcastInstance.getCluster().addMembershipListener(HazelcastClusterManager.createConnectionListener(this));
        }
    }

    private boolean isUniqueClusterStrategy(boolean multicastExplicit, boolean multicastEnabled, String clusterNodes, String discoverySpiMechanism) {
        return !multicastExplicit || !multicastEnabled || clusterNodes == null || !HazelcastUtils.validDiscoveryStrategy(discoverySpiMechanism);
    }

    private boolean isClusterStrategyEnabled(boolean multicastExplicit, boolean multicastEnabled, String clusterNodes, String discoverySpiMechanism) {
        return !multicastExplicit || multicastEnabled || clusterNodes != null || HazelcastUtils.validDiscoveryStrategy(discoverySpiMechanism);
    }

    @Override
    public void setAsPollingNode(boolean isPoller) {
        this.isPoller = isPoller;
    }

    @Override
    public ClusterLocker getPrimaryNodePollingThread() {
        return this.primaryNodePollingThread;
    }

    public static MembershipListener createConnectionListener(final ClusterManager manager) {
        return new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                if (!manager.isPrimaryPollingInstance()) {
                    return;
                }
                manager.setAsPollingNode(false);
                manager.getPrimaryNodePollingThread().notifyIfPollingNode();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
            }
        };
    }

    public static HazelcastClusterManager createManager(ClassLoaderRepository classLoaderRepository) {
        HazelcastClusterManager instance;
        try {
            instance = new HazelcastClusterManager(classLoaderRepository);
        }
        catch (IllegalArgumentException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            instance = null;
        }
        catch (IllegalStateException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException("Invalid cluster configuration: " + e.getMessage());
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException(ERROR_MESSAGE_CREATING_MANAGER, (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException(ERROR_MESSAGE_CREATING_MANAGER, (Throwable)he);
        }
        return instance;
    }

    public static synchronized boolean isDuplicateHazelCastServerInstanceRequested() {
        ClusterTicketFileLoader clusterTicketFileLoader = new ClusterTicketFileLoader();
        SystemPropertiesConfigLoader systemPropertiesConfigLoader = new SystemPropertiesConfigLoader();
        Properties clusterTicketFileProperties = clusterTicketFileLoader.load();
        Properties clusterSystemPropertiesProperties = systemPropertiesConfigLoader.load();
        Properties clusterConfigProperties = new Properties();
        clusterConfigProperties.putAll((Map<?, ?>)clusterTicketFileProperties);
        clusterConfigProperties.putAll((Map<?, ?>)clusterSystemPropertiesProperties);
        String clientModeEnabled = clusterConfigProperties.getProperty("mule.cluster.clientmode", "false");
        String clusterNodeId = clusterConfigProperties.getProperty("mule.clusterNodeId");
        return !Boolean.parseBoolean(clientModeEnabled) && HazelcastUtils.validDiscoveryStrategy(clusterConfigProperties.getProperty("mule.cluster.discoverymechanism")) && clusterNodeId != null && Hazelcast.getHazelcastInstanceByName((String)clusterNodeId) != null;
    }

    public static synchronized HazelcastClusterManager create(ClassLoaderRepository classLoaderRepository) throws InitialisationException {
        return HazelcastClusterManager.create(() -> HazelcastClusterManager.createManager(classLoaderRepository));
    }

    static HazelcastClusterManager create(Supplier<HazelcastClusterManager> instanceSupplier) throws InitialisationException {
        HazelcastClusterManager instance = instanceSupplier.get();
        if (instance != null) {
            instance.clusterPrimaryNodeNotifier = new CompositePrimaryClusterNodeNotifier();
            instance.clusterPrimaryNodeNotifier.registerListener(instance);
            int heartbeatTimeout = 500;
            if (!instance.isClientModeEnabled()) {
                String heartBeanTimeoutConfig = instance.getHazelcastInstance().getConfig().getProperty(HAZELCAST_HEARTBEAT_TIMEOUT_KEY);
                heartbeatTimeout = heartBeanTimeoutConfig != null ? Integer.valueOf(heartBeanTimeoutConfig) : heartbeatTimeout;
            }
            instance.primaryNodePollingThread = HazelcastClusterManager.createPrimaryNodePollingThread(instance, instance.clusterPrimaryNodeNotifier, heartbeatTimeout);
            instance.setSystemProperties();
            return instance;
        }
        return null;
    }

    @Override
    public boolean isClientModeEnabled() {
        String clientModeEnabled = this.clusterConfigProperties.getProperty("mule.cluster.clientmode", "false");
        return Boolean.parseBoolean(clientModeEnabled);
    }

    private void configureClientMode() {
        String clusterNodes = this.clusterConfigProperties.getProperty("mule.cluster.nodes");
        String nodeId = this.clusterConfigProperties.getProperty("mule.clusterNodeId");
        String clusterIdProp = this.clusterConfigProperties.getProperty("mule.clusterId");
        String hazelcastClusterId = this.clusterConfigProperties.getProperty("mule.cluster.clientclusterid");
        this.hazelcastInstance = hazelcastClusterId == null ? HazelcastClientInstanceBuilder.hazelcastClientInstanceBuilder().clusterNodes(clusterNodes).classLoader(this.getClass().getClassLoader()).build() : HazelcastClientInstanceBuilder.hazelcastClientInstanceBuilder().clusterNodes(clusterNodes).classLoader(this.getClass().getClassLoader()).clusterId(hazelcastClusterId).build();
        this.clusterNodeId = nodeId != null ? nodeId : String.valueOf(new Random(System.currentTimeMillis()).nextInt());
        this.clusterId = clusterIdProp;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.hazelcastInstance.getUserContext();
    }

    public void registerObjectStore(HazelcastObjectStore store) {
        this.hazelcastObjectStores.add(store);
    }

    public void unregisterObjectStore(HazelcastObjectStore store) {
        this.hazelcastObjectStores.remove(store);
    }

    public void initialise() throws MuleException {
        logger.info("Initializing Mule HA Module...");
        try {
            if (logger.isInfoEnabled() && !this.isClientModeEnabled()) {
                this.hazelcastInstance.getPartitionService().addMigrationListener((MigrationListener)new HazelcastPartitionLogger(this.hazelcastInstance));
            }
            this.primaryNodePollingThread.start();
        }
        catch (Exception e) {
            throw new DefaultMuleException(e);
        }
        logger.info("Embedded space created");
    }

    public void dispose() {
        logger.info("Disposing Mule HA Module...");
        try {
            this.primaryNodePollingThread.interrupt();
            this.primaryNodePollingThread.join(500L);
            for (HazelcastObjectStore store : this.hazelcastObjectStores) {
                store.close();
            }
            if (this.hazelcastInstance != null) {
                try {
                    this.hazelcastInstance.getLifecycleService().shutdown();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    this.hazelcastInstance = null;
                }
            }
            System.clearProperty("mule.clusterId");
            System.clearProperty("mule.clusterNodeId");
            System.clearProperty("mule.clusterSize");
        }
        catch (Exception e) {
            logger.warn("Exception disposing HA module", (Throwable)e);
        }
    }

    private void setSystemProperties() {
        System.setProperty("mule.clusterId", this.clusterId);
        System.setProperty("mule.clusterNodeId", String.valueOf(this.clusterNodeId));
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.isPoller;
    }

    @Override
    public void onNotification() {
        this.isPoller = true;
    }

    public static HazelcastClusterLocker createPrimaryNodePollingThread(HazelcastClusterManager hazelcastManager, CompositePrimaryClusterNodeNotifier clusterPrimaryNodeNotifier, int heartbeatTimeoutSecs) {
        return new HazelcastClusterLocker(HazelcastClusterManager.getClusterPoolingLockId(hazelcastManager.clusterId), hazelcastManager.getHazelcastInstance(), clusterPrimaryNodeNotifier, heartbeatTimeoutSecs);
    }

    public static String getClusterPoolingLockId(String clusterId) {
        return clusterId + "-mule.cluster.configfile";
    }

    public void unregisterPrimaryNodeListener(PrimaryClusterNodeListener primaryClusterNodeListener) {
        this.clusterPrimaryNodeNotifier.unregisterListener(primaryClusterNodeListener);
    }

    public void registerPrimaryNodeListener(PrimaryClusterNodeListener primaryClusterNodeListener) {
        this.clusterPrimaryNodeNotifier.registerListener(primaryClusterNodeListener);
    }

    public ClusterStoreProfile getDefaultClusterStoreProfile() {
        return this.defaultClusterStoreProfile;
    }

    @Override
    public void terminate() {
        this.getHazelcastInstance().getLifecycleService().terminate();
    }

    @Override
    public void shutdown() {
        this.getHazelcastInstance().getLifecycleService().shutdown();
    }

    @Override
    public int size() {
        return this.hazelcastInstance.getCluster().getMembers().size();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.getHazelcastInstance().getCluster().getLocalMember().getSocketAddress();
    }

    @Override
    public <K, V> ClusterMap<K, V> getMap(String mapId) {
        return this.clusterMaps.computeIfAbsent(mapId, key -> new HazelcastClusterMap(this.hazelcastInstance.getMap(key)));
    }
}

