/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi;

import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.DiscoveryResponse;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.DiscoveryResponseHandler;
import com.mulesoft.mule.runtime.module.cluster.internal.discoveryspi.HttpMethod;
import java.io.IOException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleHttpClient.class);

    public DiscoveryResponse request(String uri, HttpMethod httpMethod, String body) {
        try {
            DiscoveryResponse discoveryResponse = this.executeRequest(uri, httpMethod, body);
            if (!discoveryResponse.isSuccessful()) {
                LOGGER.error("Response Error for url: {} and response code: {} & response: {}", new Object[]{uri, discoveryResponse.getStatus(), discoveryResponse.getJsonBody()});
            }
            return discoveryResponse;
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public DiscoveryResponse executeRequest(String uri, HttpMethod httpMethod, String body) throws IOException {
        DiscoveryResponseHandler discoveryResponseHandler = new DiscoveryResponseHandler();
        switch (httpMethod) {
            case GET: {
                return (DiscoveryResponse)Request.Get((String)uri).execute().handleResponse((ResponseHandler)discoveryResponseHandler);
            }
            case POST: {
                return (DiscoveryResponse)Request.Post((String)uri).bodyString(body, ContentType.APPLICATION_JSON).execute().handleResponse((ResponseHandler)discoveryResponseHandler);
            }
        }
        throw new MuleRuntimeException(new Exception(String.format("Unhandled %s request", new Object[]{httpMethod})));
    }
}

