/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.lock;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.internal.lock.HazelcastLock;
import com.mulesoft.mule.runtime.module.cluster.internal.persistence.MapNameNormalizer;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lock.LockProvider;

public class HazelcastLockProvider
implements LockProvider {
    private static final String LOCKS_MAP_SUFFIX = "_locks_map";
    private static final String EXCEPTION_MESSAGE_FORMAT = "Error while creating a lock with id '%s'";
    private final String clusterId;
    private HazelcastInstance hazelcastInstance;
    private String appName;

    public HazelcastLockProvider(String clusterId, HazelcastInstance hazelcastInstance, String appName) {
        this.clusterId = clusterId;
        this.hazelcastInstance = hazelcastInstance;
        this.appName = appName;
    }

    @Override
    public Lock createLock(String lockId) {
        try {
            IMap locksMap = this.hazelcastInstance.getMap(this.getNormalizedMapName(this.clusterId + "_" + this.appName) + LOCKS_MAP_SUFFIX);
            return new HazelcastLock(locksMap, this.getNormalizedMapName(this.clusterId + "_" + this.appName) + "_" + lockId);
        }
        catch (SplitBrainProtectionException qe) {
            throw new ClusterQuorumException(String.format(EXCEPTION_MESSAGE_FORMAT, lockId), (Throwable)qe);
        }
        catch (HazelcastException he) {
            throw new ClusterRuntimeException(String.format(EXCEPTION_MESSAGE_FORMAT, lockId), (Throwable)he);
        }
    }

    private String getNormalizedMapName(String mapName) {
        return MapNameNormalizer.normalize(mapName);
    }
}

