/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.map;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.map.IMap;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterQuorumException;
import com.mulesoft.mule.runtime.module.cluster.api.exception.ClusterRuntimeException;
import com.mulesoft.mule.runtime.module.cluster.api.map.ClusterMap;
import com.mulesoft.mule.runtime.module.cluster.api.map.EntryListener;
import com.mulesoft.mule.runtime.module.cluster.internal.map.EventListenerWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class HazelcastClusterMap<K, V>
implements ClusterMap<K, V> {
    private final IMap<K, V> iMap;

    public HazelcastClusterMap(IMap<K, V> hazelcastInstanceMap) {
        this.iMap = hazelcastInstanceMap;
    }

    @Override
    public UUID addEntryListener(EntryListener<K, V> listener) {
        try {
            return this.iMap.addEntryListener(new EventListenerWrapper<K, V>(listener), true);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error adding entry listener", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error adding entry listener", (Throwable)e);
        }
    }

    @Override
    public boolean removeEntryListener(UUID id) {
        try {
            return this.iMap.removeEntryListener(id);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error removing entry listener", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error removing entry listener", (Throwable)e);
        }
    }

    @Override
    public int size() {
        try {
            return this.iMap.size();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error getting map size", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting map size", (Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.iMap.isEmpty();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error checking if map is empty", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map is empty", (Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.iMap.containsKey(key);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error checking if map contains key", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map contains key", (Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.iMap.containsValue(value);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error checking if map contains value", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error checking if map contains value", (Throwable)e);
        }
    }

    @Override
    public V get(Object key) {
        try {
            return (V)this.iMap.get(key);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error getting a value from a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting a value from a map", (Throwable)e);
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            return (V)this.iMap.put(key, value);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error putting an entry in a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error putting an entry in a map", (Throwable)e);
        }
    }

    @Override
    public V remove(Object key) {
        try {
            return (V)this.iMap.remove(key);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error removing an entry from a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error removing an entry from a map", (Throwable)e);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        try {
            this.iMap.putAll(m);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error putting in a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error putting in a map", (Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.iMap.clear();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error clearing a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error clearing a map", (Throwable)e);
        }
    }

    @Override
    public Set<K> keySet() {
        try {
            return this.iMap.keySet();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error getting the key set from a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the key set from a map", (Throwable)e);
        }
    }

    @Override
    public Collection<V> values() {
        try {
            return this.iMap.values();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error getting the values from a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the values from a map", (Throwable)e);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            return this.iMap.entrySet();
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error getting the entry set from a map", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error getting the entry set from a map", (Throwable)e);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            return (V)this.iMap.putIfAbsent(key, value);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error on putIfAbsent", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on putIfAbsent", (Throwable)e);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        try {
            return this.iMap.remove(key, value);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error on remove", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on remove", (Throwable)e);
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        try {
            return this.iMap.replace(key, oldValue, newValue);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error on replace", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on replace", (Throwable)e);
        }
    }

    @Override
    public V replace(K key, V value) {
        try {
            return (V)this.iMap.replace(key, value);
        }
        catch (SplitBrainProtectionException e) {
            throw new ClusterQuorumException("Error on replace", (Throwable)e);
        }
        catch (HazelcastException e) {
            throw new ClusterRuntimeException("Error on replace", (Throwable)e);
        }
    }
}

