/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectInputStream;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectOutputStream;

public class JdbcMapStoreSerializationProtocol
implements SerializationProtocol {
    private final ClassLoaderRepository classLoaderRepository;

    public JdbcMapStoreSerializationProtocol(ClassLoaderRepository classLoaderRepository) {
        this.classLoaderRepository = classLoaderRepository;
    }

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        try (ArtifactClassLoaderObjectOutputStream out = new ArtifactClassLoaderObjectOutputStream(this.classLoaderRepository, outputStream);){
            out.writeObject(object);
        }
        catch (IOException ex) {
            throw new SerializationException("Cannot serialize object", (Throwable)ex);
        }
        return outputStream.toByteArray();
    }

    @Override
    public void serialize(Object object, OutputStream out) throws SerializationException {
        try {
            byte[] bytes = this.serialize(object);
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new SerializationException("Could not write to output stream", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) throws SerializationException {
        Objects.requireNonNull(bytes, "The byte[] must not be null");
        return this.deserialize(bytes, null);
    }

    @Override
    public <T> T deserialize(InputStream inputStream) throws SerializationException {
        return this.deserialize(inputStream, null);
    }

    @Override
    public <T> T deserialize(byte[] bytes, ClassLoader classLoader) throws SerializationException {
        return this.deserialize(new ByteArrayInputStream(bytes), classLoader);
    }

    @Override
    public <T> T deserialize(InputStream inputStream, ClassLoader classLoader) throws SerializationException {
        Objects.requireNonNull(inputStream, "Cannot deserialize a null stream");
        try {
            Object object;
            ArtifactClassLoaderObjectInputStream in = new ArtifactClassLoaderObjectInputStream(this.classLoaderRepository, inputStream);
            try {
                object = in.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new SerializationException("Cannot deserialize object", (Throwable)ex);
                }
            }
            in.close();
            return (T)object;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

