/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.security;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.InboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import java.nio.ByteBuffer;
import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class DecrypterHandler
extends InboundHandler<ByteBuffer, ByteBuffer> {
    private static final int HEADER_SIZE = 4;
    private int valueOffset;
    private int size;
    private boolean headerRead;
    private byte[] payload;
    private boolean hasFullBlockAvailable = false;
    private final Encrypter encrypter;

    public DecrypterHandler(Encrypter encrypter) {
        this.encrypter = encrypter;
    }

    public void handlerAdded() {
        this.initSrcBuffer();
    }

    public synchronized HandlerStatus onRead() {
        ((ByteBuffer)this.src).flip();
        try {
            do {
                if (!this.tryHandleBlock()) {
                    HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                    return handlerStatus;
                }
                if (this.fetchNewBlock()) continue;
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            } while (((ByteBuffer)this.src).hasRemaining() || this.hasFullBlockAvailable);
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            IOUtil.compactOrClear((ByteBuffer)((ByteBuffer)this.src));
        }
    }

    private boolean fetchNewBlock() {
        if (!this.headerRead && ((ByteBuffer)this.src).remaining() < 4) {
            return false;
        }
        this.hasFullBlockAvailable = this.readNextChunk((ByteBuffer)this.src);
        if (this.size == 0) {
            this.reset();
            return false;
        }
        return true;
    }

    private boolean tryHandleBlock() {
        if (this.hasFullBlockAvailable) {
            return this.doHandleBlock();
        }
        return true;
    }

    private boolean doHandleBlock() {
        if (((ByteBuffer)this.dst).remaining() >= this.payload.length) {
            try {
                this.decryptBlock((ByteBuffer)this.dst);
            }
            catch (MuleEncryptionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Couldn't decrypt data"), (Throwable)e);
            }
            this.reset();
            return true;
        }
        return false;
    }

    private boolean readNextChunk(ByteBuffer src) {
        if (!this.headerRead) {
            this.size = src.getInt();
            this.payload = new byte[this.size];
            this.headerRead = true;
        }
        if (this.size > 0) {
            boolean done;
            int bytesRead;
            int bytesNeeded;
            int bytesReadable = src.remaining();
            if (bytesReadable >= (bytesNeeded = this.size - this.valueOffset)) {
                bytesRead = bytesNeeded;
                done = true;
            } else {
                bytesRead = bytesReadable;
                done = false;
            }
            src.get(this.payload, this.valueOffset, bytesRead);
            this.valueOffset += bytesRead;
            return done;
        }
        return true;
    }

    private void reset() {
        this.headerRead = false;
        this.size = 0;
        this.valueOffset = 0;
        this.payload = null;
        this.hasFullBlockAvailable = false;
    }

    private void decryptBlock(ByteBuffer dst) throws MuleEncryptionException {
        if (this.payload != null && this.payload.length > 0) {
            byte[] decrypted = this.encrypter.decrypt(this.payload);
            dst.put(decrypted);
        }
    }
}

