/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal.vm;

import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterConfigExtension;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterQueueConfiguration;
import com.mulesoft.mule.runtime.module.cluster.internal.config.ClusterStoreProfile;
import com.mulesoft.mule.runtime.module.cluster.internal.vm.ClusterQueueManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueManagerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchingClusterQueueManager
implements QueueManager,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchingClusterQueueManager.class);
    private final ClusterQueueManager clusterQueueManager;
    private final ClusterStoreProfile defaultClusterStoreProfile;
    private QueueManager resolvedQueueManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    @Named(value="_localQueueManager")
    private QueueManager localQueueManager;

    public SwitchingClusterQueueManager(ClusterQueueManager clusterQueueManager, ClusterStoreProfile defaultClusterStoreProfile) {
        this.clusterQueueManager = clusterQueueManager;
        this.defaultClusterStoreProfile = defaultClusterStoreProfile;
    }

    @Override
    public void initialise() throws InitialisationException {
        ClusterQueueConfiguration queueConfiguration = this.defaultClusterStoreProfile.getQueueConfiguration();
        ClusterConfigExtension clusterConfiguration = this.muleContext.getConfiguration().getExtension(ClusterConfigExtension.class);
        if (clusterConfiguration != null) {
            queueConfiguration = clusterConfiguration.getClusterStoreProfile().getQueueConfiguration();
        }
        if (queueConfiguration.useDistributedQueues()) {
            QueueManagerWrapper wrapperManager = new QueueManagerWrapper();
            this.resolvedQueueManager = wrapperManager;
            wrapperManager.setQueueManager(this.clusterQueueManager);
            LifecycleUtils.initialiseIfNeeded(this.clusterQueueManager, true, this.muleContext);
            this.clusterQueueManager.configureQueueBackups(queueConfiguration.getNumberOfBackups());
        } else {
            this.resolvedQueueManager = this.localQueueManager;
        }
    }

    @Override
    public QueueSession getQueueSession() {
        return this.resolvedQueueManager.getQueueSession();
    }

    @Override
    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.resolvedQueueManager.setDefaultQueueConfiguration(config);
    }

    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.resolvedQueueManager.setQueueConfiguration(queueName, config);
    }

    @Override
    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        return this.resolvedQueueManager.getQueueConfiguration(queueName);
    }

    @Override
    public void start() throws MuleException {
        this.resolvedQueueManager.start();
    }

    @Override
    public void stop() throws MuleException {
        this.resolvedQueueManager.stop();
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.resolvedQueueManager, LOGGER);
    }
}

