/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.license.internal;

import com.mulesoft.mule.runtime.core.api.license.MuleLicenseUtils;
import com.mulesoft.mule.runtime.core.api.license.NoValidLicenseFoundException;
import com.mulesoft.mule.runtime.module.boot.license.MuleLicenseException;
import com.mulesoft.mule.runtime.module.license.internal.CustomerLicense;
import com.mulesoft.mule.runtime.module.license.internal.ProviderLicense;
import com.mulesoft.mule.runtime.module.license.internal.SecurityUtils;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Optional;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.license.api.PluginLicenseValidationRequest;
import org.mule.runtime.module.license.api.exception.InvalidLicenseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EeLicenseValidator
implements LicenseValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EeLicenseValidator.class);
    private static final String MISSING_ENTITLEMENT_MSG = "The Module %s requires a license with entitlement for %s";
    private static final String PLEASE_CONTACT_MSH = "Please Contact: %s";
    private static final String MULE_PUB_KEY = "mule.pub";
    protected final PublicKey mulePublicKey;

    public EeLicenseValidator() {
        try {
            this.mulePublicKey = this.getMulePublicKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void validatePluginLicense(PluginLicenseValidationRequest pluginLicenseValidationRequest) {
        try {
            if (pluginLicenseValidationRequest.isAllowsEvaluation() && MuleLicenseUtils.getLicense().isEvaluation()) {
                return;
            }
        }
        catch (NoValidLicenseFoundException e) {
            this.throwRuntimeLicenseNotFoundException(e);
            return;
        }
        if (pluginLicenseValidationRequest.getPluginProvider().equals("Mulesoft")) {
            try {
                MuleLicenseUtils.getLicense().validateFeature(pluginLicenseValidationRequest.getEntitlement(), pluginLicenseValidationRequest.getPluginName());
            }
            catch (NoValidLicenseFoundException e) {
                this.throwRuntimeLicenseNotFoundException(e);
            }
            catch (MuleLicenseException e) {
                throw new InvalidLicenseException(String.format("Runtime license does not contain entitlement [%s] required by plugin [%s]", pluginLicenseValidationRequest.getEntitlement(), pluginLicenseValidationRequest.getPluginName()));
            }
        } else {
            this.validateThirdPartyPluginLicense(pluginLicenseValidationRequest);
        }
    }

    private void validateThirdPartyPluginLicense(PluginLicenseValidationRequest pluginLicenseValidationRequest) {
        if (MuleLicenseUtils.isTestingMode()) {
            return;
        }
        ProviderLicense providerLicense = null;
        try {
            LOGGER.debug("Loading provider data for plugin {}", (Object)pluginLicenseValidationRequest.getPluginName());
            providerLicense = this.getProviderLicense(pluginLicenseValidationRequest);
            String expectedLicenseName = providerLicense.getExpectedLicenseName();
            LOGGER.debug("Loading custom license information from license file {}", (Object)expectedLicenseName);
            CustomerLicense customLicense = new CustomerLicense(expectedLicenseName, pluginLicenseValidationRequest.getArtifactClassLoader(), providerLicense);
            if (!customLicense.isValid(pluginLicenseValidationRequest.getPluginVersion(), pluginLicenseValidationRequest.getEntitlement())) {
                this.logInvalidLicenseError(pluginLicenseValidationRequest, providerLicense, customLicense);
                throw new InvalidLicenseException(String.format(MISSING_ENTITLEMENT_MSG, pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getEntitlement()) + ". " + String.format(PLEASE_CONTACT_MSH, providerLicense.getEmail()));
            }
        }
        catch (InvalidKeyException e) {
            String email = providerLicense != null ? providerLicense.getEmail() : "";
            String msg = providerLicense != null ? providerLicense.getContactMessage() : "";
            throw new InvalidLicenseException(String.format(MISSING_ENTITLEMENT_MSG, pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getEntitlement()) + ". Contact email: " + email + ". " + msg, e);
        }
    }

    private void throwRuntimeLicenseNotFoundException(NoValidLicenseFoundException e) {
        throw new InvalidLicenseException("runtime license not found", e);
    }

    private void logInvalidLicenseError(PluginLicenseValidationRequest pluginLicenseValidationRequest, ProviderLicense providerLicense, CustomerLicense customLicense) {
        String licName = customLicense.getLicFileName();
        if (!customLicense.hasValidVersion(pluginLicenseValidationRequest.getPluginVersion())) {
            LOGGER.error("Your license {} is not valid for this connector version: {}", (Object)licName, (Object)pluginLicenseValidationRequest.getPluginVersion());
        } else if (!customLicense.hasValidEntitlement(pluginLicenseValidationRequest.getEntitlement())) {
            LOGGER.error("Your license {} does not enable the feature [{}] required by the module {}", new Object[]{licName, pluginLicenseValidationRequest.getEntitlement(), pluginLicenseValidationRequest.getPluginName()});
        } else {
            LOGGER.error("Your license {} has expired on the {}", (Object)licName, (Object)customLicense.getExpirationDate());
        }
        Optional<String> contactEmail = providerLicense.getProperty("contact.email");
        if (contactEmail.isPresent()) {
            LOGGER.error("Please get in contact with your Vendor {} using the following address: {}", (Object)providerLicense.getExpectedLicenseName(), (Object)contactEmail.orElseThrow());
        } else {
            LOGGER.error("Please get in contact with your Vendor {}", (Object)providerLicense.getExpectedLicenseName());
        }
        Optional<String> contactMessage = providerLicense.getProperty("contact.message");
        if (contactMessage.isPresent()) {
            LOGGER.error(contactMessage.orElseThrow());
        }
    }

    protected PublicKey getMulePublicKey() throws Exception {
        return SecurityUtils.loadPublic(MULE_PUB_KEY);
    }

    protected ProviderLicense getProviderLicense(PluginLicenseValidationRequest pluginLicenseValidationRequest) throws InvalidKeyException {
        return new ProviderLicense(pluginLicenseValidationRequest.getPluginProvider(), pluginLicenseValidationRequest.getPluginName(), pluginLicenseValidationRequest.getPluginClassLoader(), this.mulePublicKey);
    }
}

