/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultClassResolver;
import com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

public class ArtifactClassResolver
extends DefaultClassResolver {
    private final ClassLoaderRepository classLoaderRepository;

    public ArtifactClassResolver(ClassLoaderRepository classLoaderRepository) {
        Preconditions.checkArgument(classLoaderRepository != null, "classLoaderRepository cannot be null");
        this.classLoaderRepository = classLoaderRepository;
    }

    protected void writeName(Output output, Class type, Registration registration) {
        int nameId;
        output.writeVarInt(1, true);
        if (this.classToNameId != null && (nameId = this.classToNameId.get((Object)type, -1)) != -1) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write class name reference " + nameId + ": " + Util.className((Class)type)));
            }
            output.writeVarInt(nameId, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Write class name: " + Util.className((Class)type)));
        }
        nameId = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put((Object)type, nameId);
        output.writeVarInt(nameId, true);
        output.writeString(type.getName());
        ClassLoader classLoader = type.getClassLoader();
        String artifactId = this.classLoaderRepository.getId(classLoader).orElse(null);
        output.writeString(artifactId);
    }

    protected Registration readName(Input input) {
        Class type;
        int nameId = input.readVarInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((type = (Class)this.nameIdToClass.get(nameId)) == null) {
            String className = input.readString();
            String artifactId = input.readString();
            String artifactClassName = artifactId + ":" + className;
            type = this.getTypeByName(artifactClassName);
            if (type == null) {
                try {
                    ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    if (artifactId != null) {
                        classLoader = this.classLoaderRepository.find(artifactId).orElseThrow(() -> new IllegalStateException("Cannot find a class loader with ID: : " + artifactId));
                    }
                    type = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException var6) {
                    throw new KryoException("Unable to find class: " + artifactClassName, (Throwable)var6);
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put((Object)artifactClassName, type);
            }
            this.nameIdToClass.put(nameId, (Object)type);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read class name: " + artifactClassName));
            }
        } else if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read class name reference " + nameId + ": " + Util.className((Class)type)));
        }
        return this.kryo.getRegistration(type);
    }

    public Registration getRegistration(int classID) {
        return super.getRegistration(Math.abs(classID));
    }
}

