/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.security.SecurityContext;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.core.internal.event.DefaultEventBuilder;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.message.EventInternalContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.event.context.FlowProcessMediatorContext;

final class EventKryoSerializer
extends Serializer<InternalEvent> {
    private final FieldSerializer<DefaultEventBuilder.InternalEventImplementation> serializer;

    public EventKryoSerializer(Kryo kryo) {
        this.serializer = new FieldSerializer(kryo, DefaultEventBuilder.InternalEventImplementation.class);
    }

    public void write(Kryo kryo, Output output, InternalEvent event) {
        kryo.writeClassAndObject(output, (Object)event.getContext());
        kryo.writeClassAndObject(output, event.getError().orElse(null));
        kryo.writeClassAndObject(output, event.getItemSequenceInfo());
        kryo.writeClassAndObject(output, (Object)event.getLegacyCorrelationId());
        kryo.writeClassAndObject(output, event.getLoggingVariables().orElse(null));
        kryo.writeClassAndObject(output, (Object)event.getMessage());
        output.writeBoolean(false);
        kryo.writeClassAndObject(output, event.getParameters());
        kryo.writeClassAndObject(output, (Object)event.getSecurityContext());
        kryo.writeClassAndObject(output, MuleSession.class);
        kryo.writeClassAndObject(output, event.getVariables());
    }

    public InternalEvent read(Kryo kryo, Input input, Class<InternalEvent> type) {
        Object innerInstance;
        Constructor<?> constructor;
        Class<?> innerClass;
        BaseEventContext context = (BaseEventContext)kryo.readClassAndObject(input);
        Error error = (Error)kryo.readClassAndObject(input);
        Optional itemSequenceInfo = (Optional)kryo.readClassAndObject(input);
        if (itemSequenceInfo == null) {
            itemSequenceInfo = Optional.empty();
        }
        String legacyCorrelationId = (String)kryo.readClassAndObject(input);
        CaseInsensitiveHashMap loggingVariables = (CaseInsensitiveHashMap)kryo.readClassAndObject(input);
        Message message = (Message)kryo.readClassAndObject(input);
        boolean notificationsEnabled = input.readBoolean();
        CaseInsensitiveHashMap parameters = CaseInsensitiveHashMap.emptyCaseInsensitiveMap();
        if (!this.withoutParameters(input)) {
            parameters = (CaseInsensitiveHashMap)kryo.readClassAndObject(input);
        }
        SecurityContext securityContext = (SecurityContext)kryo.readClassAndObject(input);
        kryo.readClassAndObject(input);
        CaseInsensitiveHashMap variables = (CaseInsensitiveHashMap)kryo.readClassAndObject(input);
        Map internalParameters = Map.of();
        Object flowProcessMediatorContext = null;
        Object sdkInternalContext = null;
        Object foreachInternalContext = null;
        Object sourcePolicyContext = null;
        Object operationPolicyContext = null;
        try {
            innerClass = Class.forName("org.mule.runtime.core.internal.event.DefaultEventBuilder$InternalEventImplementation");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            constructor = innerClass.getDeclaredConstructor(BaseEventContext.class, Message.class, CaseInsensitiveHashMap.class, CaseInsensitiveHashMap.class, CaseInsensitiveHashMap.class, Map.class, SecurityContext.class, Optional.class, FlowProcessMediatorContext.class, EventInternalContext.class, EventInternalContext.class, EventInternalContext.class, EventInternalContext.class, Error.class, String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        constructor.setAccessible(true);
        try {
            innerInstance = constructor.newInstance(context, message, variables, parameters, loggingVariables, internalParameters, securityContext, itemSequenceInfo, flowProcessMediatorContext, sdkInternalContext, foreachInternalContext, sourcePolicyContext, operationPolicyContext, error, legacyCorrelationId, notificationsEnabled);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        return (InternalEvent)innerInstance;
    }

    private boolean withoutParameters(Input input) {
        Input buffer = new Input(input.getBuffer());
        buffer.setPosition(input.position());
        return buffer.readVarInt(true) == 0;
    }

    public InternalEvent copy(Kryo kryo, InternalEvent original) {
        return (InternalEvent)PrivilegedEvent.builder(original).build();
    }
}

