/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedValueKryoSerializer
extends Serializer<TypedValue> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypedValueKryoSerializer.class);
    private static final int UNDEFINED_LENGTH = -1;

    public void write(Kryo kryo, Output output, TypedValue object) {
        long length;
        DataType dataType;
        Object value;
        block4: {
            value = object.getValue();
            dataType = object.getDataType();
            length = object.getByteLength().orElse(-1L);
            if (!(value instanceof CursorStreamProvider)) break block4;
            InputStream in = null;
            try {
                in = (InputStream)((CursorStreamProvider)value).openCursor();
                value = IOUtils.toByteArray((InputStream)in);
                length = ((byte[])value).length;
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            dataType = DataType.builder(dataType).type(value.getClass()).build();
        }
        kryo.writeClassAndObject(output, value);
        kryo.writeClassAndObject(output, (Object)dataType);
        output.writeLong(length);
    }

    public TypedValue read(Kryo kryo, Input input, Class<TypedValue> type) {
        Object value = kryo.readClassAndObject(input);
        DataType dataType = (DataType)kryo.readClassAndObject(input);
        TypedValue<Object> wrappedValue = new TypedValue<Object>(value, dataType);
        int initialPosition = input.position();
        try {
            long maybeLength = input.readLong();
            long expectedLength = wrappedValue.getByteLength().orElse(-1L);
            if (maybeLength != expectedLength && !this.isLegacyByteArrayFromStream(value, maybeLength)) {
                input.setPosition(initialPosition);
            }
        }
        catch (KryoException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to read value length. Will assume we are in legacy mode and reset the cursor");
            }
            input.setPosition(initialPosition);
        }
        return wrappedValue;
    }

    private boolean isLegacyByteArrayFromStream(Object value, long length) {
        return value instanceof byte[] && length == -1L;
    }
}

