/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.plugin.InvalidPropertyNameException;
import com.mulesoft.mule.runtime.plugin.factory.PluginConfigurer;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDescriptor;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import com.mulesoft.mule.runtime.plugin.manager.PluginLifecycleException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;

public class ManagedMulePlugin
implements Artifact<ServerPluginDescriptor>,
PluginConfigurer,
PluginPropertyDiscoverer,
Lifecycle {
    private final ServerPluginDescriptor descriptor;
    private final MulePlugin plugin;
    private boolean enabled = true;
    private PluginConfigurer pluginConfigurer = new NullPluginConfigurer();
    private PluginPropertyDiscoverer propertyDiscoverer = new NullPluginPropertyDiscoverer();
    private final ArtifactClassLoader artifactClassLoader;

    public ManagedMulePlugin(ServerPluginDescriptor descriptor, MulePlugin plugin, ArtifactClassLoader artifactClassLoader) {
        Preconditions.checkArgument(descriptor != null, "Plugin descriptor cannot be null");
        Preconditions.checkArgument(plugin != null, "Plugin cannot be null");
        Preconditions.checkArgument(artifactClassLoader != null, "Artifact class loader cannot be null");
        this.descriptor = descriptor;
        this.plugin = plugin;
        this.artifactClassLoader = artifactClassLoader;
    }

    public void setPluginConfigurer(PluginConfigurer pluginConfigurer) {
        this.pluginConfigurer = pluginConfigurer;
    }

    public void setPropertyDiscoverer(PluginPropertyDiscoverer propertyDiscoverer) {
        this.propertyDiscoverer = propertyDiscoverer;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.artifactClassLoader.getArtifactId();
    }

    @Override
    public ServerPluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public File[] getResourceFiles() {
        return new File[0];
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.artifactClassLoader;
    }

    public MulePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public List<PluginPropertyDescriptor> discoverProperties() {
        return this.propertyDiscoverer.discoverProperties();
    }

    @Override
    public void configure(Map<String, String> properties) {
        List<PluginPropertyDescriptor> propertyDescriptors = this.discoverProperties();
        this.validatePropertyNames(properties, propertyDescriptors);
        this.pluginConfigurer.configure(properties);
        if (this.enabled && this.hasStaticProperty(propertyDescriptors)) {
            this.restartPlugin();
        }
    }

    private void restartPlugin() {
        try {
            this.plugin.stop();
            this.plugin.start();
        }
        catch (MuleException e) {
            throw new PluginLifecycleException(String.format("Error restarting plugin '%s'", this.descriptor.getName()), e);
        }
    }

    private void validatePropertyNames(Map<String, String> properties, List<PluginPropertyDescriptor> propertyDescriptors) {
        for (String propertyName : properties.keySet()) {
            if (this.hasProperty(propertyDescriptors, propertyName)) continue;
            throw new InvalidPropertyNameException(propertyName);
        }
    }

    private boolean hasProperty(List<PluginPropertyDescriptor> descriptors, String propertyName) {
        for (PluginPropertyDescriptor descriptor : descriptors) {
            if (!descriptor.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStaticProperty(List<PluginPropertyDescriptor> descriptors) {
        for (PluginPropertyDescriptor descriptor : descriptors) {
            if (descriptor.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stop() throws MuleException {
        this.plugin.stop();
    }

    @Override
    public void dispose() {
        this.plugin.dispose();
        this.artifactClassLoader.dispose();
    }

    @Override
    public void start() throws MuleException {
        this.plugin.start();
    }

    @Override
    public void initialise() throws InitialisationException {
        this.plugin.initialise();
    }

    private static class NullPluginConfigurer
    implements PluginConfigurer {
        private NullPluginConfigurer() {
        }

        @Override
        public void configure(Map<String, String> properties) {
        }
    }

    private static class NullPluginPropertyDiscoverer
    implements PluginPropertyDiscoverer {
        private NullPluginPropertyDiscoverer() {
        }

        @Override
        public List<PluginPropertyDescriptor> discoverProperties() {
            return Collections.emptyList();
        }
    }
}

