/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.plugin.factory;

import com.mulesoft.mule.runtime.module.plugin.api.MulePlugin;
import com.mulesoft.mule.runtime.plugin.ManagedMulePlugin;
import com.mulesoft.mule.runtime.plugin.classloader.ClassLoaderInjectorInvocationHandler;
import com.mulesoft.mule.runtime.plugin.factory.InvalidPluginClassException;
import com.mulesoft.mule.runtime.plugin.factory.PluginConfigurer;
import com.mulesoft.mule.runtime.plugin.factory.PluginConfigurerFactory;
import com.mulesoft.mule.runtime.plugin.factory.PluginFactory;
import com.mulesoft.mule.runtime.plugin.factory.PluginInstantiationException;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDiscoverer;
import com.mulesoft.mule.runtime.plugin.factory.PluginPropertyDiscovererFactory;
import com.mulesoft.mule.runtime.plugin.factory.ServerPluginDescriptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.exception.ArtifactClassloaderCreationException;

public class MulePluginFactory
implements PluginFactory {
    private final ArtifactClassLoaderFactory<ServerPluginDescriptor> classLoaderFactory;
    private final PluginConfigurerFactory configurerFactory;
    private final PluginPropertyDiscovererFactory propertyDiscovererFactory;
    private final ArtifactClassLoader parentClassLoader;
    private final Injector containerInjector;

    public MulePluginFactory(ArtifactClassLoaderFactory<ServerPluginDescriptor> classLoaderFactory, PluginPropertyDiscovererFactory propertyDiscovererFactory, PluginConfigurerFactory configurerFactory, ArtifactClassLoader parentClassLoader, Injector containerInjector) {
        this.classLoaderFactory = classLoaderFactory;
        this.configurerFactory = configurerFactory;
        this.propertyDiscovererFactory = propertyDiscovererFactory;
        this.parentClassLoader = parentClassLoader;
        this.containerInjector = containerInjector;
    }

    public static String getServerPluginId(String pluginName) {
        return "plugin/" + pluginName;
    }

    @Override
    public ManagedMulePlugin create(ServerPluginDescriptor descriptor) throws PluginInstantiationException {
        ArtifactClassLoader artifactClassLoader;
        String artifactId = MulePluginFactory.getServerPluginId(descriptor.getName());
        try {
            artifactClassLoader = this.classLoaderFactory.create(artifactId, descriptor, this.parentClassLoader.getClassLoader(), this.parentClassLoader.getClassLoaderLookupPolicy());
        }
        catch (ArtifactClassloaderCreationException e) {
            throw new PluginInstantiationException("Error creating classloader for plugin '" + artifactId + "'", e);
        }
        MulePlugin plugin = this.instantiatePlugin(artifactClassLoader.getClassLoader(), descriptor.getClassName());
        Class<?>[] interfaces = ClassUtils.findImplementedInterfaces(plugin.getClass());
        MulePlugin proxyPlugin = (MulePlugin)ClassLoaderInjectorInvocationHandler.createProxy(plugin, artifactClassLoader.getClassLoader(), interfaces);
        proxyPlugin.setWorkingDirectory(descriptor.getRootFolder());
        PluginConfigurer pluginConfigurer = this.configurerFactory.create(plugin);
        PluginPropertyDiscoverer propertyDiscoverer = this.propertyDiscovererFactory.create(plugin);
        ManagedMulePlugin managedPlugin = new ManagedMulePlugin(descriptor, proxyPlugin, artifactClassLoader);
        managedPlugin.setPluginConfigurer(pluginConfigurer);
        managedPlugin.setPropertyDiscoverer(propertyDiscoverer);
        return managedPlugin;
    }

    private MulePlugin instantiatePlugin(ClassLoader classLoader, String className) {
        Object reflectedObject;
        try {
            reflectedObject = Class.forName(className, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new PluginInstantiationException("Unable to create plugin from class: " + className, e);
        }
        if (!(reflectedObject instanceof MulePlugin)) {
            throw new InvalidPluginClassException(className);
        }
        try {
            this.containerInjector.inject(reflectedObject);
        }
        catch (MuleException e) {
            throw new PluginInstantiationException("Cannot inject plugin instance", e);
        }
        return (MulePlugin)reflectedObject;
    }
}

