/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.tracking.api.event;

import com.mulesoft.mule.runtime.tracking.api.event.EventNotification;
import com.mulesoft.mule.runtime.tracking.internal.i18n.TrackingMessages;
import jakarta.inject.Inject;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractEventNotificationFiringMessageProcessor
extends AbstractComponent
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.mulesoft.mule.runtime.tracking");
    @Inject
    protected ExtendedExpressionManager expressionManager;
    @Inject
    private NotificationDispatcher notificationFirer;

    @Override
    public final CoreEvent process(CoreEvent event) throws MuleException {
        block2: {
            try {
                this.notificationFirer.dispatch(this.createNotification(event));
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn(TrackingMessages.exceptionWhileFiringEvent(EventNotification.class.getSimpleName(), event).toString(), (Throwable)e);
            }
        }
        return event;
    }

    protected abstract EventNotification createNotification(CoreEvent var1);

    protected final EventNotification createNotification(CoreEvent muleEvent, String name, String transactionId, Map<String, String> metaDatas) {
        return new EventNotification(EnrichedNotificationInfo.createInfo(muleEvent, null, this), this.getLocation().getRootContainerName(), name, this.extractValue(StringUtils.trim((String)transactionId), muleEvent), metaDatas);
    }

    protected final String extractValue(String value, CoreEvent event) {
        block4: {
            if (value == null) {
                return null;
            }
            try {
                if (this.expressionManager.isExpression(value)) {
                    return this.expressionManager.parse(value, event, this.getLocation());
                }
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn(TrackingMessages.exceptionWhileParsingValueExpression(value, event.getMessage()).toString(), (Throwable)e);
            }
        }
        return value;
    }
}

