/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.tracking.internal.event;

import com.mulesoft.mule.runtime.tracking.api.event.AbstractEventNotificationFiringMessageProcessor;
import com.mulesoft.mule.runtime.tracking.api.event.EventNotification;
import com.mulesoft.mule.runtime.tracking.internal.config.EventTemplate;
import com.mulesoft.mule.runtime.tracking.internal.i18n.TrackingMessages;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.dsl.api.component.MapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMessageProcessor
extends AbstractEventNotificationFiringMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.mulesoft.mule.runtime.tracking");
    @Inject
    private Registry registry;
    protected String name;
    protected Map<String, String> metaData = new HashMap<String, String>();
    protected String inherits;

    @Override
    protected final EventNotification createNotification(CoreEvent muleEvent) {
        HashMap<String, String> expandedMetaDatas;
        HashMap<String, String> allMetaData;
        block7: {
            allMetaData = new HashMap<String, String>(this.metaData);
            expandedMetaDatas = new HashMap<String, String>();
            if (this.inherits != null) {
                try {
                    Optional template = this.registry.lookupByName(this.inherits);
                    if (!template.isPresent()) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn(TrackingMessages.nonExistingInheritedTemplate(this.inherits).toString());
                        }
                    } else {
                        allMetaData.putAll(((EventTemplate)template.get()).getMetaData());
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block7;
                    LOGGER.warn(TrackingMessages.exceptionWhileAccessingInheritedTemplate(this.inherits).toString(), (Throwable)e);
                }
            }
        }
        for (Map.Entry entry : allMetaData.entrySet()) {
            String key = StringUtils.trim((String)((String)entry.getKey()));
            String value = StringUtils.trim((String)((String)entry.getValue()));
            expandedMetaDatas.put(key, this.extractValue(value, muleEvent));
        }
        return this.createNotification(muleEvent, this.name, null, expandedMetaDatas);
    }

    public final void setEventName(String name) {
        this.name = name;
    }

    public void setMetaData(Map<String, String> metaData) {
        this.metaData = metaData;
    }

    public void setMetaDataCollection(Collection<MapEntry<String, String>> metaDataCollection) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (MapEntry<String, String> entry : metaDataCollection) {
            result.put(entry.getKey(), entry.getValue());
        }
        this.setMetaData(result);
    }

    public final void setInherits(String inherits) {
        this.inherits = inherits;
    }
}

