/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public abstract class AbstractImportValidation
implements ArtifactValidation {
    @Override
    public List<ValidationResultItem> validateMany(ArtifactAst artifact) {
        return artifact.getImportedResources().stream().filter(imp -> imp.getResolutionFailure().isPresent()).filter(imp -> this.appliesValidationFor(imp.getResolutionFailure().get())).map(imp -> {
            String message = imp.getResolutionFailure().get();
            return ValidationResultItem.create((ComponentAst)new ImportComponentAst(imp.getMetadata()), this, message, message.startsWith("Could not resolve imported resource "));
        }).collect(Collectors.toList());
    }

    protected abstract boolean appliesValidationFor(String var1);

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return h -> true;
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        return this.validate(artifact);
    }

    private static final class ImportComponentAst
    extends BaseComponentAst {
        private final ComponentMetadataAst metadata;

        public ImportComponentAst(ComponentMetadataAst metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentMetadataAst getMetadata() {
            return this.metadata;
        }

        @Override
        public MetadataType getType() {
            return null;
        }

        @Override
        public Collection<ComponentParameterAst> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public <M> Optional<M> getModel(Class<M> modelClass) {
            return Optional.empty();
        }

        @Override
        public ComponentLocation getLocation() {
            return null;
        }

        @Override
        public ComponentIdentifier getIdentifier() {
            return ComponentIdentifier.builder().namespace("mule").name("import").build();
        }

        @Override
        public ComponentGenerationInformation getGenerationInformation() {
            return null;
        }

        @Override
        public ExtensionModel getExtensionModel() {
            return null;
        }

        @Override
        public TypedComponentIdentifier.ComponentType getComponentType() {
            return TypedComponentIdentifier.ComponentType.UNKNOWN;
        }

        @Override
        public Optional<String> getComponentId() {
            return Optional.empty();
        }

        @Override
        public Map<String, Object> getAnnotations() {
            return Collections.emptyMap();
        }

        @Override
        public List<ComponentAst> directChildren() {
            return Collections.emptyList();
        }
    }
}

