/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorValidation;

public class ErrorHandlerOnErrorTypeNonPropertyValue
extends AbstractErrorValidation {
    @Override
    public String getName() {
        return "Error Type references fixed";
    }

    @Override
    public String getDescription() {
        return "Referenced error types are fixed.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> (comp.getIdentifier().equals(ON_ERROR_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_PROPAGATE_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_CONTINUE_IDENTIFIER)) && this.isErrorTypePresentAndPropertyDependant((ComponentAst)comp));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst onErrorComponent, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = this.getErrorTypeParam(onErrorComponent);
        String errorTypeRawValue = errorTypeParam.getRawValue();
        if (MuleAstUtils.hasPropertyPlaceholder(errorTypeRawValue)) {
            return Optional.of(ValidationResultItem.create(onErrorComponent, errorTypeParam, (Validation)this, "'" + onErrorComponent.getIdentifier().getName() + "' has 'type' '" + errorTypeRawValue + "' which is resolved with a property and may cause the artifact to have different behavior on different environments."));
        }
        return Optional.empty();
    }
}

