/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import com.google.common.io.FileWriteMode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.api.discoverer.ModuleDiscoverer;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.core.internal.util.PropertiesUtils;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClasspathModuleDiscoverer
implements ModuleDiscoverer {
    private static final String TMP_FOLDER_SUFFIX = "tmp";
    private static Logger logger = LoggerFactory.getLogger(ClasspathModuleDiscoverer.class);
    public static final String MODULE_PROPERTIES = "META-INF/mule-module.properties";
    private final Function<String, File> serviceInterfaceToServiceFile;
    private final BiFunction<String, File, URL> fileToResource;
    private final String modulePropertiesResource;

    public ClasspathModuleDiscoverer() {
        this(ClasspathModuleDiscoverer.createModulesTemporaryFolder());
    }

    public ClasspathModuleDiscoverer(String modulePropertiesResource) {
        this(ClasspathModuleDiscoverer.createModulesTemporaryFolder(), modulePropertiesResource);
    }

    public ClasspathModuleDiscoverer(File temporaryFolder) {
        this(temporaryFolder, MODULE_PROPERTIES);
    }

    public ClasspathModuleDiscoverer(File temporaryFolder, String modulePropertiesResource) {
        this.serviceInterfaceToServiceFile = serviceInterface -> this.wrappingInIllegalStateException(() -> Files.createTempFile(temporaryFolder.toPath(), serviceInterface, TMP_FOLDER_SUFFIX, new FileAttribute[0]).toFile(), (String)serviceInterface);
        this.fileToResource = (serviceInterface, serviceFile) -> this.wrappingInIllegalStateException(() -> serviceFile.toURI().toURL(), (String)serviceInterface);
        this.modulePropertiesResource = modulePropertiesResource;
    }

    private <T> T wrappingInIllegalStateException(CheckedSupplier<T> supplier, String serviceInterface) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error creating temporary service provider file for '%s'", serviceInterface), e);
        }
    }

    public ClasspathModuleDiscoverer(Function<String, File> serviceInterfaceToServiceFile, BiFunction<String, File, URL> fileToResource, String modulePropertiesResource) {
        this.serviceInterfaceToServiceFile = serviceInterfaceToServiceFile;
        this.fileToResource = fileToResource;
        this.modulePropertiesResource = modulePropertiesResource;
    }

    protected static File createModulesTemporaryFolder() {
        File modulesTempFolder = MuleFoldersUtil.getModulesTempFolder();
        if (modulesTempFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)modulesTempFolder);
            }
            catch (IOException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not clean up folder %s, validate that the process has permissions over that directory", modulesTempFolder.getAbsolutePath())));
            }
        } else if (!modulesTempFolder.mkdirs()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not create folder %s, validate that the process has permissions over that directory", modulesTempFolder.getAbsolutePath())));
        }
        return modulesTempFolder;
    }

    @Override
    public List<MuleContainerModule> discover() {
        LinkedList<MuleContainerModule> modules = new LinkedList<MuleContainerModule>();
        HashSet<String> moduleNames = new HashSet<String>();
        try {
            for (Properties moduleProperties : PropertiesUtils.discoverProperties(this.getClass().getClassLoader(), this.getModulePropertiesFileName())) {
                MuleModule module = this.createModule(moduleProperties);
                if (moduleNames.contains(module.getName())) {
                    logger.warn(String.format("Ignoring duplicated module '%s'", module.getName()));
                    continue;
                }
                moduleNames.add(module.getName());
                modules.add(module);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot discover mule modules", e);
        }
        return modules;
    }

    protected String getModulePropertiesFileName() {
        return this.modulePropertiesResource;
    }

    public MuleModule createModule(Properties moduleProperties) {
        String moduleName = (String)moduleProperties.get("module.name");
        Set<String> modulePackages = this.getExportedPackageByProperty(moduleProperties, "artifact.export.classPackages");
        Set<String> modulePaths = this.getExportedResourcePaths(moduleProperties);
        Set<String> modulePrivilegedPackages = this.getExportedPackageByProperty(moduleProperties, "artifact.privileged.classPackages");
        Set<String> privilegedArtifacts = this.getPrivilegedArtifactIds(moduleProperties);
        List<ExportedService> exportedServices = this.getExportedServices(moduleProperties, "artifact.export.services");
        return new MuleModule(moduleName, modulePackages, modulePaths, modulePrivilegedPackages, privilegedArtifacts, exportedServices);
    }

    private List<ExportedService> getExportedServices(Properties moduleProperties, String exportedServicesProperty) {
        String exportedPackagesProperty = (String)moduleProperties.get(exportedServicesProperty);
        List<ExportedService> exportedServices = !StringUtils.isEmpty((CharSequence)exportedPackagesProperty) ? this.getServicesFromProperty(exportedPackagesProperty) : Collections.emptyList();
        return exportedServices;
    }

    private List<ExportedService> getServicesFromProperty(String exportedPackagesProperty) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (String exportedServiceDefinition : exportedPackagesProperty.split(",")) {
            URL resource;
            String[] split = exportedServiceDefinition.split(":");
            String serviceInterface = split[0];
            String serviceImplementation = split[1];
            try {
                File serviceFile = this.serviceInterfaceToServiceFile.apply(serviceInterface);
                serviceFile.deleteOnExit();
                com.google.common.io.Files.asCharSink((File)serviceFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)serviceImplementation);
                resource = this.fileToResource.apply(serviceInterface, serviceFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error creating temporary service provider file for '%s'", serviceInterface), e);
            }
            exportedServices.add(new ExportedService(serviceInterface, resource));
        }
        return exportedServices;
    }

    private Set<String> getPrivilegedArtifactIds(Properties moduleProperties) {
        String privilegedArtifactsProperty = (String)moduleProperties.get("artifact.privileged.artifactIds");
        HashSet<String> artifactsIds = new HashSet<String>();
        if (!StringUtils.isEmpty((CharSequence)privilegedArtifactsProperty)) {
            for (String artifactName : privilegedArtifactsProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)artifactName.trim())) continue;
                artifactsIds.add(artifactName);
            }
        }
        HashSet<String> privilegedArtifacts = artifactsIds;
        return privilegedArtifacts;
    }

    private Set<String> getExportedPackageByProperty(Properties moduleProperties, String privilegedExportedClassPackagesProperty) {
        String privilegedExportedPackagesProperty = (String)moduleProperties.get(privilegedExportedClassPackagesProperty);
        Set<String> modulePrivilegedPackages = !StringUtils.isEmpty((CharSequence)privilegedExportedPackagesProperty) ? this.getPackagesFromProperty(privilegedExportedPackagesProperty) : new HashSet<String>();
        return modulePrivilegedPackages;
    }

    private Set<String> getExportedResourcePaths(Properties moduleProperties) {
        HashSet<String> paths = new HashSet<String>();
        String exportedResourcesProperty = (String)moduleProperties.get("artifact.export.resources");
        if (!StringUtils.isEmpty((CharSequence)exportedResourcesProperty)) {
            for (String path : exportedResourcesProperty.split(",")) {
                if (StringUtils.isEmpty((CharSequence)path.trim())) continue;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                paths.add(path);
            }
        }
        return paths;
    }

    private Set<String> getPackagesFromProperty(String privilegedExportedPackagesProperty) {
        HashSet<String> packages = new HashSet<String>();
        for (String packageName : privilegedExportedPackagesProperty.split(",")) {
            if (StringUtils.isEmpty((CharSequence)(packageName = packageName.trim()))) continue;
            packages.add(packageName);
        }
        return packages;
    }
}

